/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.localization;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.tizen.web.localization.LocaleItem;
import org.tizen.web.localization.LocalizationPlugin;

public class LocaleLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        return this.getImage(element);
    }

    public String getColumnText(Object element, int columnIndex) {
        return this.getText(element);
    }

    public String getText(Object obj) {
        if (obj instanceof LocaleItem) {
            return this.getObjectText((LocaleItem)obj);
        }
        return super.getText(obj);
    }

    public Image getImage(Object obj) {
        if (obj instanceof LocaleItem) {
            Image image = null;
            LocaleItem localeItem = (LocaleItem)obj;
            if (localeItem.isPreSelected()) {
                ImageDescriptor imageDecriptor = LocalizationPlugin.getImageDescriptor("icons/language-selector-ltgrayed.png");
                if (imageDecriptor != null) {
                    image = this.get(imageDecriptor);
                }
            } else {
                ImageDescriptor imageDecriptor = LocalizationPlugin.getImageDescriptor("icons/language-selector.png");
                if (imageDecriptor != null) {
                    image = this.get(imageDecriptor);
                }
            }
            return image;
        }
        return super.getImage(obj);
    }

    public String getObjectText(LocaleItem obj) {
        return obj.getLocale().getLanguage();
    }

    public Image get(ImageDescriptor desc) {
        return desc.createImage();
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        LocaleItem localeItem = (LocaleItem)element;
        if (localeItem.isPreSelected()) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            return display.getSystemColor(15);
        }
        return null;
    }
}

