/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.initializer;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.compiler.libraries.LibraryLocation;
import org.tizen.web.editor.configuration.ConfigurationException;
import org.tizen.web.editor.configuration.ConfiguratorFactory;
import org.tizen.web.editor.configuration.ITizenConfigurator;
import org.tizen.web.project.Activator;
import org.tizen.web.project.initializer.LibraryProvider;

public class WebLibraryLocation
implements LibraryLocation {
    public static String LIB_DIR = "JSlibraries";
    private ITizenConfigurator config = null;
    private IProject project;

    public WebLibraryLocation(IProject project) {
        this.project = project;
        try {
            this.config = ConfiguratorFactory.unmarshalWidgetConfiguration((IProject)project);
        }
        catch (ConfigurationException configurationException) {
            this.config = null;
        }
    }

    protected String getPluginId() {
        return "org.tizen.web.project";
    }

    public IPath getLibraryPathInPlugin() {
        return new Path(LIB_DIR);
    }

    public char[][] getLibraryFileNames() {
        if (this.config == null) {
            return new char[0][0];
        }
        LibraryProvider libraryReferrer = LibraryProvider.getInstance();
        return libraryReferrer.getLibraryFileNames(this.getConfiguration(), this.getWorkingLibPath());
    }

    public IPath getWorkingLibraryBasePath() {
        return Activator.getDefault().getStateLocation().append(LIB_DIR);
    }

    public IPath getWorkingLibPath() {
        return this.getWorkingLibraryBasePath().append(this.project.getName());
    }

    public String getLibraryPath(String name) {
        return this.getWorkingLibPath().append(name).toOSString();
    }

    public String getLibraryPath(char[] name) {
        return this.getLibraryPath(new String(name));
    }

    public ITizenConfigurator getConfiguration() {
        return this.config;
    }
}

