/*
 * Decompiled with CFR 0.152.
 */
package json.outline;

import json.outline.JsonTextOutlineParserException;
import json.outline.Messages;
import json.outline.elements.JsonArray;
import json.outline.elements.JsonBoolean;
import json.outline.elements.JsonElement;
import json.outline.elements.JsonError;
import json.outline.elements.JsonNull;
import json.outline.elements.JsonNumber;
import json.outline.elements.JsonObject;
import json.outline.elements.JsonParent;
import json.outline.elements.JsonString;
import json.util.JsonCharUtility;
import json.util.reader.JsonDocReader;
import json.util.reader.JsonReader;
import json.util.reader.JsonReaderException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;

public class JsonTextOutlineParser {
    private JsonReader parser;
    private JsonParent root;
    private JsonParent parent;
    private IDocument doc;

    public JsonTextOutlineParser(IDocument doc) {
        this.parser = new JsonDocReader(doc);
        this.doc = doc;
    }

    public JsonParent parse() {
        block4: {
            try {
                char current = this.parser.getNextClean();
                if (current == '{') {
                    this.doJsonObject("", this.parser.getPosition());
                    break block4;
                }
                if (current == '[') {
                    this.doJsonArray("", this.parser.getPosition());
                    break block4;
                }
                JsonError jsonError = new JsonError(this.parent, Messages.JsonTextOutlineParser_0);
                this.root = new JsonObject(this.parent, "");
                this.root.addChild(jsonError);
                throw new JsonTextOutlineParserException();
            }
            catch (Exception exception) {}
        }
        return this.root;
    }

    private void doJsonObject(String key, int startPos) throws JsonReaderException, JsonTextOutlineParserException, BadLocationException, BadPositionCategoryException {
        char ch;
        JsonObject jsonObject = new JsonObject(this.parent, key);
        if (this.root == null) {
            this.parent = this.root = jsonObject;
        } else {
            this.parent.addChild(jsonObject);
            this.parent = jsonObject;
        }
        jsonObject.setPosition(startPos, this.parser.getPosition() - startPos + 1, this.doc);
        do {
            if ((ch = this.parser.getNextClean()) == '}') {
                this.parser.getNextClean();
                this.parent = ((JsonElement)((Object)this.parent)).getParent();
                break;
            }
            if (ch != '\"') {
                JsonError jsonError = new JsonError(this.parent, Messages.JsonTextOutlineParser_4);
                this.parent.addChild(jsonError);
                throw new JsonTextOutlineParserException();
            }
            int start = this.parser.getPosition();
            String attributeKey = this.doJsonKey();
            ch = this.parser.getNextClean();
            if (ch != ':') {
                JsonError jsonError = new JsonError(this.parent, Messages.JsonTextOutlineParser_5);
                this.parent.addChild(jsonError);
                throw new JsonTextOutlineParserException();
            }
            ch = this.parser.getNextClean();
            if (ch == '{') {
                this.doJsonObject(attributeKey, start);
            } else if (ch == '[') {
                this.doJsonArray(attributeKey, start);
            } else if (ch == 'n') {
                this.doJsonNull(attributeKey, start);
            } else if (ch == '\"') {
                this.doJsonValue(attributeKey, start);
            } else if (ch == 't') {
                this.doJsonTrueValue(attributeKey, start);
            } else if (ch == 'f') {
                this.doJsonFalseValue(attributeKey, start);
            } else if (Character.isDigit(ch) || ch == '-') {
                this.doJsonNumber(attributeKey, start);
            } else {
                JsonError jsonError = new JsonError(this.parent, Messages.JsonTextOutlineParser_6);
                this.parent.addChild(jsonError);
                throw new JsonTextOutlineParserException();
            }
            ch = this.parser.getCurrent();
            if (ch == ',') continue;
            if (ch == '}') {
                this.parser.getNextClean();
                this.parent = ((JsonElement)((Object)this.parent)).getParent();
                break;
            }
            JsonError jsonError = new JsonError(this.parent, String.valueOf(Messages.JsonTextOutlineParser_7) + ch);
            this.parent.addChild(jsonError);
            throw new JsonTextOutlineParserException();
        } while (ch != '\uffff');
    }

    private void doJsonArray(String key, int startPos) throws JsonReaderException, JsonTextOutlineParserException, BadLocationException, BadPositionCategoryException {
        char ch;
        JsonArray jsonArray = new JsonArray(this.parent, key);
        if (this.root == null) {
            this.parent = this.root = jsonArray;
        } else {
            this.parent.addChild(jsonArray);
            this.parent = jsonArray;
        }
        jsonArray.setPosition(startPos, this.parser.getPosition() - startPos + 1, this.doc);
        do {
            ch = this.parser.getNextClean();
            int start = this.parser.getPosition();
            if (ch == '{') {
                this.doJsonObject("", start);
            } else if (ch == '[') {
                this.doJsonArray("", start);
            } else if (ch == 'n') {
                this.doJsonNull("", start);
            } else if (ch == '\"') {
                this.doJsonValue("", start);
            } else if (ch == 't') {
                this.doJsonTrueValue("", start);
            } else if (ch == 'f') {
                this.doJsonFalseValue("", start);
            } else if (Character.isDigit(ch) || ch == '-') {
                this.doJsonNumber("", start);
            } else {
                if (ch == ']') {
                    this.parser.getNextClean();
                    this.parent = ((JsonElement)((Object)this.parent)).getParent();
                    break;
                }
                JsonError jsonError = new JsonError(this.parent, Messages.JsonTextOutlineParser_15);
                this.parent.addChild(jsonError);
                throw new JsonTextOutlineParserException();
            }
            ch = this.parser.getCurrent();
            if (ch == ',') continue;
            if (ch == ']') {
                this.parser.getNextClean();
                this.parent = ((JsonElement)((Object)this.parent)).getParent();
                break;
            }
            JsonError jsonError = new JsonError(this.parent, String.valueOf(Messages.JsonTextOutlineParser_16) + ch);
            this.parent.addChild(jsonError);
            throw new JsonTextOutlineParserException();
        } while (ch != '\uffff');
    }

    private void doJsonTrueValue(String key, int start) throws JsonReaderException, JsonTextOutlineParserException, BadLocationException, BadPositionCategoryException {
        JsonBoolean jsonBoolean = new JsonBoolean(this.parent, key);
        this.parent.addChild(jsonBoolean);
        jsonBoolean.setStart(start, this.doc);
        char ch = this.parser.getNextChar();
        if (ch != 'r') {
            JsonError jsonError = new JsonError(this.parent, Messages.JsonTextOutlineParser_17);
            this.parent.addChild(jsonError);
            throw new JsonTextOutlineParserException();
        }
        ch = this.parser.getNextChar();
        if (ch != 'u') {
            JsonError jsonError = new JsonError(this.parent, Messages.JsonTextOutlineParser_18);
            this.parent.addChild(jsonError);
            throw new JsonTextOutlineParserException();
        }
        ch = this.parser.getNextChar();
        if (ch != 'e') {
            JsonError jsonError = new JsonError(this.parent, Messages.JsonTextOutlineParser_19);
            this.parent.addChild(jsonError);
            throw new JsonTextOutlineParserException();
        }
        jsonBoolean.setLength(this.parser.getPosition() - start + 1);
        ch = this.parser.getNextClean();
        if (JsonCharUtility.isNotClosed(ch)) {
            JsonError jsonError = new JsonError(this.parent, Messages.JsonTextOutlineParser_20);
            this.parent.addChild(jsonError);
            throw new JsonTextOutlineParserException();
        }
        jsonBoolean.setValue("true");
    }

    private void doJsonFalseValue(String key, int start) throws JsonReaderException, JsonTextOutlineParserException, BadLocationException, BadPositionCategoryException {
        JsonBoolean jsonBoolean = new JsonBoolean(this.parent, key);
        this.parent.addChild(jsonBoolean);
        jsonBoolean.setStart(start, this.doc);
        char ch = this.parser.getNextChar();
        if (ch != 'a') {
            JsonError jsonError = new JsonError(this.parent, Messages.JsonTextOutlineParser_22);
            this.parent.addChild(jsonError);
            throw new JsonTextOutlineParserException();
        }
        ch = this.parser.getNextChar();
        if (ch != 'l') {
            JsonError jsonError = new JsonError(this.parent, Messages.JsonTextOutlineParser_23);
            this.parent.addChild(jsonError);
            throw new JsonTextOutlineParserException();
        }
        ch = this.parser.getNextChar();
        if (ch != 's') {
            JsonError jsonError = new JsonError(this.parent, Messages.JsonTextOutlineParser_24);
            this.parent.addChild(jsonError);
            throw new JsonTextOutlineParserException();
        }
        ch = this.parser.getNextChar();
        if (ch != 'e') {
            JsonError jsonError = new JsonError(this.parent, Messages.JsonTextOutlineParser_25);
            this.parent.addChild(jsonError);
            throw new JsonTextOutlineParserException();
        }
        jsonBoolean.setLength(this.parser.getPosition() - start + 1);
        ch = this.parser.getNextClean();
        if (JsonCharUtility.isNotClosed(ch)) {
            JsonError jsonError = new JsonError(this.parent, Messages.JsonTextOutlineParser_26);
            this.parent.addChild(jsonError);
            throw new JsonTextOutlineParserException();
        }
        jsonBoolean.setValue("false");
    }

    private void doJsonNull(String key, int start) throws JsonReaderException, JsonTextOutlineParserException, BadLocationException, BadPositionCategoryException {
        JsonNull jsonNull = new JsonNull(this.parent, key);
        this.parent.addChild(jsonNull);
        jsonNull.setStart(start, this.doc);
        char ch = this.parser.getNextChar();
        if (ch != 'u') {
            JsonError jsonError = new JsonError(this.parent, Messages.JsonTextOutlineParser_28);
            this.parent.addChild(jsonError);
            throw new JsonTextOutlineParserException();
        }
        ch = this.parser.getNextChar();
        if (ch != 'l') {
            JsonError jsonError = new JsonError(this.parent, Messages.JsonTextOutlineParser_29);
            this.parent.addChild(jsonError);
            throw new JsonTextOutlineParserException();
        }
        ch = this.parser.getNextChar();
        if (ch != 'l') {
            JsonError jsonError = new JsonError(this.parent, Messages.JsonTextOutlineParser_30);
            this.parent.addChild(jsonError);
            throw new JsonTextOutlineParserException();
        }
        jsonNull.setLength(this.parser.getPosition() - start + 1);
        ch = this.parser.getNextClean();
        if (JsonCharUtility.isNotClosed(ch)) {
            JsonError jsonError = new JsonError(this.parent, Messages.JsonTextOutlineParser_31);
            this.parent.addChild(jsonError);
            throw new JsonTextOutlineParserException();
        }
        jsonNull.setValue("null");
    }

    private void doJsonValue(String key, int start) throws JsonReaderException, JsonTextOutlineParserException, BadLocationException, BadPositionCategoryException {
        char ch;
        JsonString jsonString = new JsonString(this.parent, key);
        this.parent.addChild(jsonString);
        jsonString.setStart(start, this.doc);
        StringBuilder valueBuilder = new StringBuilder();
        do {
            if ((ch = this.parser.getNextChar()) == '\uffff' || ch == '\"' && this.parser.getPrevious() != '\\') {
                jsonString.setLength(this.parser.getPosition() - start + 1);
                ch = this.parser.getNextClean();
                break;
            }
            valueBuilder.append(ch);
        } while (ch != '\uffff');
        jsonString.setValue(valueBuilder.toString());
    }

    private void doJsonNumber(String key, int start) throws JsonReaderException, JsonTextOutlineParserException, BadLocationException, BadPositionCategoryException {
        char ch;
        boolean decimalPointSet = false;
        JsonNumber jsonNumber = new JsonNumber(this.parent, key);
        this.parent.addChild(jsonNumber);
        jsonNumber.setStart(start, this.doc);
        StringBuilder numberBuilder = new StringBuilder();
        numberBuilder.append(this.parser.getCurrent());
        do {
            if (Character.isDigit(ch = this.parser.getNextChar())) {
                numberBuilder.append(ch);
                continue;
            }
            if (!decimalPointSet && ch == '.') {
                decimalPointSet = true;
                numberBuilder.append(ch);
                continue;
            }
            jsonNumber.setLength(this.parser.getPosition() - start);
            if (JsonCharUtility.isClosed(ch)) break;
            if (JsonCharUtility.isNotWhiteSpace(ch)) {
                JsonError jsonError = new JsonError(this.parent, String.valueOf(Messages.JsonTextOutlineParser_33) + ch + Messages.JsonTextOutlineParser_34);
                this.parent.addChild(jsonError);
                throw new JsonTextOutlineParserException();
            }
            ch = this.parser.getNextClean();
            if (!JsonCharUtility.isNotClosed(ch)) break;
            JsonError jsonError = new JsonError(this.parent, Messages.JsonTextOutlineParser_35);
            this.parent.addChild(jsonError);
            throw new JsonTextOutlineParserException();
        } while (ch != '\uffff');
        jsonNumber.setValue(numberBuilder.toString());
    }

    private String doJsonKey() throws JsonReaderException, JsonTextOutlineParserException {
        char ch;
        StringBuilder keyBuilder = new StringBuilder();
        do {
            if ((ch = this.parser.getNextChar()) == '\uffff') {
                JsonError jsonError = new JsonError(this.parent, Messages.JsonTextOutlineParser_36);
                this.parent.addChild(jsonError);
                throw new JsonTextOutlineParserException();
            }
            if (ch == '\"' && this.parser.getPrevious() != '\\') break;
            keyBuilder.append(ch);
        } while (ch != '\uffff');
        return keyBuilder.toString();
    }
}

