/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.html.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.tizen.web.editor.html.refactoring.WebFileRefactoringConstants;
import org.tizen.web.editor.html.refactoring.WebFileRenameChange;

public class WebFileRenameParticipant
extends RenameParticipant
implements WebFileRefactoringConstants {
    private String oldName = null;
    private String newName = null;
    private IPath resourcePath = null;
    private IFile srcFile = null;

    protected boolean initialize(Object element) {
        if (element instanceof IFile) {
            boolean isImage;
            String extension = ((IFile)element).getFileExtension();
            if (extension == null || extension.trim().equals("")) {
                return false;
            }
            WebFileRefactoringConstants.FileExtension fileExtension = WebFileRefactoringConstants.FileExtension.getFileExtension(extension = extension.toLowerCase());
            if (fileExtension == null && (isImage = (fileExtension = WebFileRefactoringConstants.FileExtension.UNKNOWN).isImage(extension))) {
                fileExtension = WebFileRefactoringConstants.FileExtension.IMAGE;
            }
            switch (fileExtension) {
                case HTML: 
                case HTM: 
                case JS: 
                case CSS: 
                case IMAGE: {
                    this.srcFile = (IFile)element;
                    this.resourcePath = this.srcFile.getFullPath();
                    this.oldName = this.srcFile.getName();
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String getName() {
        return "tizen-web-file-rename-refactoring";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        this.newName = this.getArguments().getNewName();
        return null;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new WebFileRenameChange(this.resourcePath, this.srcFile, this.oldName, this.newName);
    }
}

