/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.rest.ui.model;

import org.tizen.common.rest.constants.IRestUIConstants;

public class RestAPIModel {
    private static final int DEFAULT_COUNT_PARAMETERS = 5;
    private static final int DEFAULT_COUNT_PARAMETERS_ON_FILE_POST = 6;
    private String elementName;
    private String[] parameterNames;
    private String signature;
    private String method;
    private boolean isFilePost;

    public RestAPIModel(String elementName, String[] parameterNames) {
        this.elementName = elementName;
        this.parameterNames = parameterNames;
        this.method = this.extractMethod(this.elementName);
        this.signature = this.makeSignature();
        this.isFilePost = parameterNames.length == 6;
    }

    private String makeSignature() {
        StringBuffer buf = new StringBuffer();
        buf.append(String.valueOf(this.elementName) + "(");
        int count = this.parameterNames.length;
        if (count > 0) {
            int i = 0;
            while (i < count) {
                buf.append(" " + this.parameterNames[i]);
                if (i < count - 1) {
                    buf.append(", ");
                }
                ++i;
            }
        }
        buf.append(");");
        return buf.toString();
    }

    private String extractMethod(String elementName) {
        String[] methods;
        String[] stringArray = methods = IRestUIConstants.DEFAULT_METHOD_COMBO_ITEMS;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            String method = stringArray[n2];
            if (elementName.startsWith(method.substring(0, 3).toLowerCase())) {
                return method;
            }
            ++n2;
        }
        return "";
    }

    public String getMethod() {
        return this.method;
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getSignature() {
        return this.signature;
    }

    public String[] getParameterNames() {
        return this.parameterNames;
    }

    public boolean isFilePost() {
        return this.isFilePost;
    }

    public String toString() {
        return "[" + this.method + "] " + this.getSignature();
    }
}

