/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.compressor.minifier.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.tizen.common.util.IOUtil;
import org.tizen.web.compressor.minifier.core.AbstractMinifier;
import org.tizen.web.compressor.minifier.core.HTMLCompressor;
import org.tizen.web.compressor.minifier.core.IMinifier;
import org.tizen.web.compressor.minifier.core.JavaScriptErrorReporter;

public class HTMLMinifier
extends AbstractMinifier
implements IMinifier {
    protected static final String[] HTML_FILE_EXTENSIONS = new String[]{"htm", "html"};

    public HTMLMinifier() {
        super(HTML_FILE_EXTENSIONS);
    }

    @Override
    public void compress(InputStream source, OutputStream target) throws IOException {
        HTMLCompressor compressor = new HTMLCompressor();
        compressor.setCompressJavaScript(true);
        compressor.setCompressCss(true);
        compressor.setYuiErrorReporter(new JavaScriptErrorReporter());
        String compressedHtml = compressor.compress(IOUtil.getString((InputStream)source, (boolean)true));
        target.write(compressedHtml.getBytes());
    }
}

