/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.wizard.model;

import java.io.File;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.common.ui.wizards.model.Category;
import org.tizen.common.ui.wizards.model.Template;
import org.tizen.common.util.StringUtil;
import org.tizen.web.apptemplate.model.BuildProperty;
import org.tizen.web.apptemplate.model.Options;
import org.tizen.web.common.core.JAXBUtil;

public class ProjectTemplate
extends Template {
    private String widgetType;
    private String templateRoot;
    private String templateId;
    private Options templateOptions;
    private List<BuildProperty> buildProperties;
    private Options templateOptionsForRestore;

    public ProjectTemplate() {
    }

    public ProjectTemplate(Category parent, String name, String descPath) {
        this(parent, name, descPath, null);
    }

    public ProjectTemplate(Category parent, String name, String descPath, ProfileInfo profileInfo) {
        super(parent, name, descPath);
        this.setProfileInfo(profileInfo);
    }

    public String getWidgetType() {
        return this.widgetType;
    }

    public void setWidgetType(String widgetType) {
        this.widgetType = widgetType;
    }

    public String getTemplateRoot() {
        return this.templateRoot;
    }

    public void setTemplateRoot(String templateRoot) {
        this.templateRoot = templateRoot;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public ImageDescriptor getIconImage() {
        String iconPath = this.getIconPath();
        if (StringUtil.isEmpty((CharSequence)iconPath)) {
            return null;
        }
        String iconFullPath = String.valueOf(this.templateRoot) + File.separator + iconPath;
        return ImageDescriptor.createFromFile(null, (String)iconFullPath);
    }

    public Options getTemplateOptions() {
        return this.templateOptions;
    }

    public void setTemplateOptions(Options templateOptions) {
        this.templateOptionsForRestore = templateOptions;
        this.restoreDefaultTemplateOptions();
    }

    public void restoreDefaultTemplateOptions() {
        if (this.templateOptionsForRestore != null) {
            try {
                JAXBElement copiedElement = JAXBUtil.copyJAXBElement((Object)this.templateOptionsForRestore);
                this.templateOptions = (Options)copiedElement.getValue();
            }
            catch (JAXBException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public boolean equalsTemplateType(String type) {
        return this.widgetType == type;
    }

    public List<BuildProperty> getBuildProperties() {
        return this.buildProperties;
    }

    public void setBuildProperties(List<BuildProperty> buildProperties) {
        this.buildProperties = buildProperties;
    }
}

