/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.tizen.privilege.support;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.tizen.common.util.ValidationUtil;
import org.tizen.web.editor.configuration.ITizenConfigurator;
import org.tizen.web.editor.configuration.Messages;
import org.tizen.web.editor.widl.model.PrivilegeWrapper;

public class AddPrivilegePage
extends WizardPage {
    private static final String[] ACCEPTED_EXTENSIONS = new String[]{"*.xml;*.widlprocxml"};
    private RESPONSE_KIND selection;
    private ITizenConfigurator configurator;
    private Button internalRadio;
    private Text internalsFilterText;
    private Table internalTable;
    private String[] internalsAvailablePrivilegeLists;
    private Button nameRadio;
    private Text nameInputField;
    private Button fileRadio;
    private Text filePathField;
    private Button fileBrowseButton;
    private Collection<String> knownPrivileges;
    private Collection<String> addedPrivileges;

    protected AddPrivilegePage(String pageName, ITizenConfigurator configurator) {
        super(pageName);
        this.setPageComplete(false);
        this.configurator = configurator;
        this.knownPrivileges = new HashSet<String>();
        for (PrivilegeWrapper privilegeWrapper : configurator.getKnownPrivileges()) {
            this.knownPrivileges.add(privilegeWrapper.getName());
        }
        this.addedPrivileges = new HashSet<String>();
        for (PrivilegeWrapper privilegeWrapper : configurator.getUsedPrivileges()) {
            this.addedPrivileges.add(privilegeWrapper.getName());
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite baseComposite = new Composite(parent, 0);
        GridLayout fileLayout = new GridLayout(2, false);
        baseComposite.setLayout((Layout)fileLayout);
        baseComposite.setLayoutData((Object)new GridData(768));
        this.internalRadio = new Button(baseComposite, 16);
        this.internalRadio.setText(Messages.AddPrivilegePage_InternalCheckboxLabel);
        this.internalsFilterText = new Text(baseComposite, 2048);
        this.internalsFilterText.setLayoutData((Object)new GridData(4, 1, false, false));
        new Label(baseComposite, 0).setVisible(false);
        this.internalTable = new Table(baseComposite, 2848);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 150;
        this.internalTable.setLayoutData((Object)data);
        this.nameRadio = new Button(baseComposite, 16);
        this.nameRadio.setText(Messages.AddPrivilegePage_PrivilegeNameTextLabel);
        this.nameInputField = new Text(baseComposite, 2048);
        this.nameInputField.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fileRadio = new Button(baseComposite, 16);
        this.fileRadio.setText(Messages.AddPrivilegePage_FileTextLabel);
        Composite fileComposite = new Composite(baseComposite, 0);
        GridLayout grid = new GridLayout(2, false);
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        grid.verticalSpacing = 0;
        grid.horizontalSpacing = 0;
        fileComposite.setLayout((Layout)grid);
        fileComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.filePathField = new Text(fileComposite, 2056);
        this.filePathField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fileBrowseButton = new Button(fileComposite, 8);
        this.fileBrowseButton.setText(org.tizen.common.Messages.BrowserButtonLabel);
        this.fileBrowseButton.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.internalsFilterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddPrivilegePage.this.internalTable.removeAll();
                String strfilter = AddPrivilegePage.this.internalsFilterText.getText().trim();
                if (strfilter.isEmpty()) {
                    int i = 0;
                    while (i < AddPrivilegePage.this.internalsAvailablePrivilegeLists.length) {
                        TableItem item = new TableItem(AddPrivilegePage.this.internalTable, 0);
                        item.setText(AddPrivilegePage.this.internalsAvailablePrivilegeLists[i]);
                        ++i;
                    }
                    return;
                }
                String[] stringArray = AddPrivilegePage.this.internalsAvailablePrivilegeLists;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String privilegeName = stringArray[n2];
                    if (privilegeName.contains(strfilter)) {
                        TableItem item = new TableItem(AddPrivilegePage.this.internalTable, 0);
                        item.setText(privilegeName);
                    }
                    ++n2;
                }
            }
        });
        this.internalRadio.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AddPrivilegePage.this.changeSelection(RESPONSE_KIND.PRIVILEGE_INTERNAL);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        HashSet<String> availablePrivilegeNames = new HashSet<String>();
        for (PrivilegeWrapper privilegeWrapper : this.configurator.getKnownPrivileges()) {
            availablePrivilegeNames.add(privilegeWrapper.getName());
        }
        for (PrivilegeWrapper privilegeWrapper : this.configurator.getUsedPrivileges()) {
            availablePrivilegeNames.remove(privilegeWrapper.getName());
        }
        if (!availablePrivilegeNames.isEmpty()) {
            this.internalsAvailablePrivilegeLists = availablePrivilegeNames.toArray(new String[availablePrivilegeNames.size()]);
            Arrays.sort(this.internalsAvailablePrivilegeLists, 0, this.internalsAvailablePrivilegeLists.length, String.CASE_INSENSITIVE_ORDER);
            int i = 0;
            while (i < this.internalsAvailablePrivilegeLists.length) {
                TableItem item = new TableItem(this.internalTable, 0);
                item.setText(this.internalsAvailablePrivilegeLists[i]);
                ++i;
            }
            this.internalRadio.setSelection(true);
            this.changeSelection(RESPONSE_KIND.PRIVILEGE_INTERNAL);
        } else {
            this.internalsFilterText.setEnabled(false);
            this.internalRadio.setEnabled(false);
            this.internalTable.setEnabled(false);
            this.nameRadio.setSelection(true);
            this.changeSelection(RESPONSE_KIND.PRIVILEGE_NAME);
        }
        this.nameRadio.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                AddPrivilegePage.this.changeSelection(RESPONSE_KIND.PRIVILEGE_NAME);
            }
        });
        this.nameInputField.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = !Character.isWhitespace(e.character);
            }
        });
        this.nameInputField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddPrivilegePage.this.validatePage();
            }
        });
        this.fileRadio.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                AddPrivilegePage.this.changeSelection(RESPONSE_KIND.PRIVILEGE_FILE);
            }
        });
        this.fileBrowseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                AddPrivilegePage.this.browseFiles();
            }
        });
        Dialog.applyDialogFont((Control)baseComposite);
        this.setControl((Control)baseComposite);
    }

    private void changeSelection(RESPONSE_KIND kind) {
        this.selection = kind;
        this.internalsFilterText.setEnabled(RESPONSE_KIND.PRIVILEGE_INTERNAL == this.selection);
        this.internalTable.setEnabled(RESPONSE_KIND.PRIVILEGE_INTERNAL == this.selection);
        this.nameInputField.setEnabled(RESPONSE_KIND.PRIVILEGE_NAME == this.selection);
        this.filePathField.setEnabled(RESPONSE_KIND.PRIVILEGE_FILE == this.selection);
        this.fileBrowseButton.setEnabled(RESPONSE_KIND.PRIVILEGE_FILE == this.selection);
        this.validatePage();
    }

    private void browseFiles() {
        FileDialog dialog = new FileDialog(this.filePathField.getShell());
        dialog.setFilterExtensions(ACCEPTED_EXTENSIONS);
        dialog.setText(Messages.AddPrivilegePage_FileDialogTitle);
        String fileName = this.filePathField.getText();
        if (!fileName.isEmpty()) {
            dialog.setFilterPath(fileName);
        } else {
            dialog.setFilterPath(null);
        }
        String resultLocation = dialog.open();
        if (resultLocation != null) {
            this.filePathField.setText(resultLocation);
        }
        this.validatePage();
    }

    protected void validatePage() {
        boolean canFinish = true;
        String message = null;
        if (RESPONSE_KIND.PRIVILEGE_NAME == this.selection) {
            String privilegeName = this.nameInputField.getText().trim();
            if (privilegeName.isEmpty()) {
                canFinish = false;
                message = null;
            }
            try {
                new URI(privilegeName);
            }
            catch (URISyntaxException uRISyntaxException) {
                canFinish = false;
                message = Messages.AddPrivilegePage_PrivilegeNameTextInvalid;
            }
            if (this.knownPrivileges.contains(privilegeName)) {
                canFinish = false;
                message = Messages.AddPrivilegePage_PrivilegeNameTextConflict;
            }
            if (this.addedPrivileges.contains(privilegeName)) {
                canFinish = false;
                message = Messages.AddPrivilegePage_PrivilegeNameTextPredefined;
            }
            if (!ValidationUtil.checkForPrivilege((String)privilegeName)) {
                canFinish = false;
                message = MessageFormat.format(Messages.Validator_InvalidPrivilegeName, privilegeName);
            }
        }
        if (RESPONSE_KIND.PRIVILEGE_FILE == this.selection) {
            String fileLocation = this.filePathField.getText();
            if (fileLocation.isEmpty()) {
                canFinish = false;
                message = null;
            } else {
                File file = new File(fileLocation);
                if (!file.canRead()) {
                    canFinish = false;
                    message = Messages.AddPrivilegePage_FileDialogInvalid;
                }
                String fileName = file.getName();
                IFolder definitionFolder = this.configurator.getProject().getFolder("external-idls");
                IFile definitionFile = definitionFolder.getFile(fileName);
                if (definitionFile.exists()) {
                    canFinish = false;
                    message = Messages.AddPrivilegePage_FileDialogPreImported;
                }
            }
        }
        this.setErrorMessage(message);
        this.setPageComplete(canFinish);
    }

    public RESPONSE_KIND getResultKind() {
        return this.selection;
    }

    public String getPrivilegeName() {
        String privilegeName = this.nameInputField.getText().trim();
        return privilegeName;
    }

    public TableItem[] getInternalPrivilegeNames() {
        return this.internalTable.getItems();
    }

    public File getPrivilegeFile() {
        String fileName = this.filePathField.getText();
        return new File(fileName);
    }

    public static enum RESPONSE_KIND {
        PRIVILEGE_NAME,
        PRIVILEGE_FILE,
        PRIVILEGE_INTERNAL;

    }
}

