/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.html.refactoring.extraction;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptCodeExtractorNameInputDialog
extends InputDialog {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String ERROR_MESSAGE_DUPLICATED = "The entered name is duplicated.";
    private static final String ERROR_MESSAGE_NOT_JS = "The javascript file name must be ended with .js file extension.";
    private static final String JS_FILE_EXTENSION = ".js";
    private IInputValidator validator = null;
    private IResource parentResource = null;
    private IResource matchedResource = null;
    private boolean isFolder = false;

    public ScriptCodeExtractorNameInputDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, IInputValidator validator, boolean isFolder, IResource parentResource) {
        super(parentShell, dialogTitle, dialogMessage, initialValue, validator);
        this.validator = validator;
        this.parentResource = parentResource;
        this.isFolder = isFolder;
    }

    protected void validateInput() {
        String errorMessage = null;
        String input = this.getText().getText();
        if (this.validator != null) {
            errorMessage = this.validator.isValid(input);
        }
        Button button = this.getButton(0);
        if (errorMessage != null) {
            if (button != null) {
                button.setEnabled(false);
            }
        } else {
            try {
                if (button != null) {
                    this.matchedResource = null;
                    boolean checkDuplication = this.checkDuplication(input, this.isFolder);
                    if (checkDuplication) {
                        errorMessage = ERROR_MESSAGE_DUPLICATED;
                        button.setEnabled(false);
                    } else {
                        button.setEnabled(true);
                    }
                    if (!this.isFolder) {
                        boolean endsWith = input.toLowerCase().endsWith(JS_FILE_EXTENSION);
                        if (!endsWith) {
                            errorMessage = ERROR_MESSAGE_NOT_JS;
                            button.setEnabled(false);
                        } else {
                            button.setEnabled(true);
                        }
                    }
                }
            }
            catch (CoreException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        this.setErrorMessage(errorMessage);
    }

    private boolean checkDuplication(final String input, final boolean isFolder) throws CoreException {
        boolean isDuplicated = false;
        IProject project = null;
        project = this.parentResource instanceof IProject ? (IProject)this.parentResource : this.parentResource.getProject();
        if (project != null) {
            project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    String resourceName;
                    int type = resource.getType();
                    if (resource.getParent().equals((Object)ScriptCodeExtractorNameInputDialog.this.parentResource) && (isFolder ? type == 2 : type == 1) && (resourceName = resource.getName()) != null && resourceName.equals(input)) {
                        ScriptCodeExtractorNameInputDialog.this.matchedResource = resource;
                        return false;
                    }
                    return true;
                }
            });
        }
        if (this.matchedResource != null) {
            isDuplicated = true;
        }
        return isDuplicated;
    }
}

