/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.builder.ide;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.builder.BuildDependencyListener;
import org.tizen.common.builder.IBuildDependency;
import org.tizen.common.builder.IBuildListener;
import org.tizen.common.builder.IBuildProcess;
import org.tizen.common.builder.IBuilder;
import org.tizen.common.builder.dependency.DependencyInMemory;
import org.tizen.common.builder.exception.BuildException;
import org.tizen.common.builder.ide.IdeBuildProcess;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.ResourceUtil;
import org.tizen.common.util.log.UserLogger;
import org.tizen.web.builder.AbstractLintBuilder;
import org.tizen.web.builder.PrivilegeCheckBuilder;
import org.tizen.web.builder.WebWidgetHtmlCssValidatorBuilder;
import org.tizen.web.builder.WebWidgetJSValidatorBuilder;
import org.tizen.web.builder.ide.Messages;
import org.tizen.web.builder.ide.listener.ErrorMarkListener;
import org.tizen.web.builder.ide.manager.BuildManager;
import org.tizen.web.builder.ide.manager.ResourceManager;
import org.tizen.web.builder.ide.visitor.WebConfigValidationVisitor;
import org.tizen.web.common.WebConstant;
import org.tizen.web.common.util.PackageUtil;
import org.tizen.web.privilege.core.PrivilegeCheckHelper;
import org.tizen.web.webwidget.validator.Activator;
import org.tizen.web.webwidget.validator.core.HtmlCssValidatorCheckHelper;
import org.tizen.web.webwidget.validator.core.JSValidatorCheckHelper;

public class WebWidgetBuilder
extends IncrementalProjectBuilder {
    public static final String MARKER_ID = "org.tizen.webwidget.builder.marker.validator";
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected void clean(IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        this.logger.debug("Clean the {} project...", (Object)project.getName());
        super.clean(monitor);
        IFolder folder = project.getFolder(".build");
        if (!folder.exists()) {
            folder.create(true, true, null);
        }
        folder.delete(true, null);
        project.deleteMarkers(MARKER_ID, false, 2);
        Collection<org.tizen.common.file.IResource> originResources = ResourceManager.getOriginResources(project);
        if (originResources != null) {
            originResources.clear();
        }
        FileUtil.recursiveDelete((File)new File(PackageUtil.getPackagePath((IProject)project)));
    }

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor mainMonitor) throws CoreException {
        UserLogger.start((String)"webWidget.build");
        IProject project = this.getProject();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)mainMonitor, (int)100);
        SubMonitor child1 = subMonitor.newChild(50);
        this.logger.debug("Build start : {}, build type : {}", (Object)project.getName(), (Object)kind);
        project.refreshLocal(2, (IProgressMonitor)child1);
        IResourceDelta delta = this.getDelta(project);
        project.deleteMarkers(MARKER_ID, false, 0);
        ResourceManager resourceManager = new ResourceManager(project);
        resourceManager.setExcludes(this.getExcludesPattern().toArray(new String[0]));
        this.updateResourceState(resourceManager, project, kind);
        if (kind != 15 && delta == null) {
            kind = 6;
        }
        this.handleMonitorCancel(mainMonitor);
        Collection<org.tizen.common.file.IResource> deltaResources = resourceManager.getDeltaResources();
        this.validateConfig(kind, project, deltaResources);
        this.handleMonitorCancel(mainMonitor);
        IdeBuildProcess buildProcess = new IdeBuildProcess(mainMonitor);
        buildProcess.addListener((IBuildListener)new BuildDependencyListener(BuildManager.getBuildDependency(project.getName(), (IBuildDependency)new DependencyInMemory())));
        this.generateBuilder((IBuildProcess)buildProcess, mainMonitor);
        this.handleMonitorCancel(mainMonitor);
        try {
            buildProcess.build(deltaResources.toArray(new org.tizen.common.file.IResource[0]));
        }
        catch (BuildException e) {
            this.forgetLastBuiltState();
            throw new CoreException((IStatus)new Status(4, "org.tizen.web.webwidget.builder", Messages.WeBWidgetBuilder_ERR_BUILD, (Throwable)e));
        }
        this.logger.debug("build end : {}", (Object)project.getName());
        UserLogger.end((String)"webWidget.build");
        return null;
    }

    private void validateConfig(int kind, IProject project, Collection<org.tizen.common.file.IResource> deltaResources) throws CoreException {
        IResource configRes = project.findMember("config.xml");
        boolean needToCheck = true;
        switch (kind) {
            case 10: {
                org.tizen.common.file.IResource configResource = ResourceUtil.getResource((String)"config.xml", (org.tizen.common.file.IResource[])deltaResources.toArray(new org.tizen.common.file.IResource[0]));
                if (configResource != null) break;
                needToCheck = false;
                break;
            }
        }
        if (needToCheck) {
            WebConfigValidationVisitor validationVisitor = new WebConfigValidationVisitor(project);
            if (configRes == null) {
                IMarker marker = project.createMarker(MARKER_ID);
                marker.setAttribute("severity", 2);
                marker.setAttribute("priority", 2);
                marker.setAttribute("message", (Object)Messages.CONFIG_RESOURCE_DOES_NOT_EXIST);
            } else {
                project.deleteMarkers(MARKER_ID, false, 0);
                configRes.accept((IResourceVisitor)validationVisitor);
            }
        }
    }

    private Collection<String> getExcludesPattern() {
        HashSet<String> excludes = new HashSet<String>();
        excludes.add(PackageUtil.getPackageName((IProject)this.getProject()));
        excludes.addAll(Arrays.asList(WebConstant.DEFAULT_EXCLUDING_RESOURCES));
        return excludes;
    }

    private void updateResourceState(ResourceManager resourceManager, IProject project, int kind) throws CoreException {
        switch (kind) {
            case 9: 
            case 10: {
                this.logger.debug("Update resource state.");
                this.getDelta(project).accept((IResourceDeltaVisitor)resourceManager);
                break;
            }
            default: {
                project.accept((IResourceVisitor)resourceManager);
            }
        }
    }

    private void generateBuilder(IBuildProcess buildProcess, IProgressMonitor monitor) {
        buildProcess.addBuilders(this.createPrivilegeCheckBuilder());
        buildProcess.addBuilders(this.createWebWidgetValidatorBuilder(monitor));
    }

    private IBuilder[] createWebWidgetValidatorBuilder(IProgressMonitor monitor) {
        ArrayList<AbstractLintBuilder> builders = new ArrayList<AbstractLintBuilder>();
        IProject project = this.getProject();
        IPreferenceStore webWidgetPreferenceStore = Activator.getWebWidgetPreferenceStore();
        if (webWidgetPreferenceStore.getBoolean("org.tizen.web.webwidget.Validator.preference.WebWidgetHtmlCssValidator.PreferencePage.build")) {
            WebWidgetHtmlCssValidatorBuilder webWidgetHtmlCssValidatorBuilder = new WebWidgetHtmlCssValidatorBuilder(project, new ErrorMarkListener(project, MARKER_ID), monitor);
            webWidgetHtmlCssValidatorBuilder.setExcludes(HtmlCssValidatorCheckHelper.getExcludeResources());
            webWidgetHtmlCssValidatorBuilder.setExcludeFolders(HtmlCssValidatorCheckHelper.getExcludeFolders());
            builders.add(webWidgetHtmlCssValidatorBuilder);
        }
        if (webWidgetPreferenceStore.getBoolean("org.tizen.web.webwidget.Validator.preference.WebWidgetJSValidator.PreferencePage.build")) {
            WebWidgetJSValidatorBuilder webWidgetJSValidatorBuilder = new WebWidgetJSValidatorBuilder(project, new ErrorMarkListener(project, MARKER_ID), monitor);
            webWidgetJSValidatorBuilder.setExcludes(JSValidatorCheckHelper.getExcludeJavaScriptResources());
            webWidgetJSValidatorBuilder.setExcludeFolders(JSValidatorCheckHelper.getExcludeFolders());
            builders.add(webWidgetJSValidatorBuilder);
        }
        return builders.toArray(new IBuilder[0]);
    }

    private IBuilder[] createPrivilegeCheckBuilder() {
        ArrayList<PrivilegeCheckBuilder> builders = new ArrayList<PrivilegeCheckBuilder>();
        IPreferenceStore privilegePreferenceStore = org.tizen.web.privilege.Activator.getPrivilegPreferenceStore();
        if (privilegePreferenceStore.getBoolean("org.tizen.web.privilege.preference.PrivilegePreferencePage.build")) {
            IProject project = this.getProject();
            PrivilegeCheckBuilder privilegeCheckBuilder = new PrivilegeCheckBuilder(project, (IBuildListener)new ErrorMarkListener(project, "org.tizen.web.builder.marker.privilege"));
            privilegeCheckBuilder.setExcludes(PrivilegeCheckHelper.getExcludeFiles());
            privilegeCheckBuilder.setExcludeFolders(PrivilegeCheckHelper.getExcludeFolders());
            privilegeCheckBuilder.setCheckingErrorLevel(PrivilegeCheckHelper.getErrorLevel());
            builders.add(privilegeCheckBuilder);
        }
        return builders.toArray(new IBuilder[0]);
    }

    private void handleMonitorCancel(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }
}

