/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.feature.support;

import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.TableItem;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.ValidationUtil;
import org.tizen.web.editor.configuration.ITizenConfigurator;
import org.tizen.web.editor.configuration.Messages;
import org.tizen.web.editor.configuration.feature.support.AddFeaturePage;

public class AddFeatureWizard
extends Wizard {
    private IProject project;
    private ITizenConfigurator configurator;
    private AddFeaturePage page;

    public AddFeatureWizard(ITizenConfigurator config) {
        this.configurator = config;
        this.project = config.getProject();
        this.setWindowTitle(Messages.AddFeatureWizard_Title);
    }

    public void addPages() {
        this.page = new AddFeaturePage(Messages.AddFeatureWizard_Title, this.configurator);
        this.page.setTitle(MessageFormat.format(Messages.AddFeatureWizard_PageTitle, this.project.getName()));
        this.page.setDescription(Messages.AddFeatureWizard_PageDescription);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        TableItem item;
        TableItem[] featureNames;
        TableItem[] tableItemArray = featureNames = this.page.getInternalFeatureNames();
        int n = featureNames.length;
        int n2 = 0;
        while (n2 < n) {
            String feature;
            item = tableItemArray[n2];
            if (item.getChecked() && ValidationUtil.checkForWarningFeature((String)(feature = item.getText()))) {
                String errorMsg = "";
                if (feature.equalsIgnoreCase("http://tizen.org/feature/screen.size.all")) {
                    errorMsg = Messages.AddFeatureWizard_WarningAllScreenSize;
                } else if (feature.equalsIgnoreCase("http://tizen.org/feature/screen.size.normal")) {
                    errorMsg = Messages.AddFeatureWizard_WarningNormalScreenSize;
                }
                if (DialogUtil.openQuestionDialog((String)errorMsg) == 128) {
                    return false;
                }
            }
            ++n2;
        }
        tableItemArray = featureNames;
        n = featureNames.length;
        n2 = 0;
        while (n2 < n) {
            item = tableItemArray[n2];
            if (item.getChecked()) {
                this.configurator.setFeature(item.getText());
            }
            ++n2;
        }
        return true;
    }
}

