/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.tizen.account.support;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;
import org.tizen.web.common.WebConstant;
import org.tizen.web.config.schema.model.Capability;
import org.tizen.web.editor.configuration.support.AbstractChangeListener;

public class CapabilityEditingSupport
extends EditingSupport {
    private int column;
    private CellEditor editor;
    private AbstractChangeListener listener;
    private static final String EMPTY_STRING = "";
    private String capabilityContent = "";

    public CapabilityEditingSupport(ColumnViewer viewer, int column) {
        super(viewer);
        this.column = column;
        switch (column) {
            case 0: {
                if (!(viewer instanceof TableViewer)) break;
                this.editor = new ComboBoxCellEditor((Composite)((TableViewer)viewer).getTable(), WebConstant.ACCOUNT_CAPABILITY_TYPES, 4){

                    protected Object doGetValue() {
                        String tempOperation = ((CCombo)this.getControl()).getText();
                        if (!tempOperation.isEmpty()) {
                            CapabilityEditingSupport.this.capabilityContent = tempOperation;
                        }
                        return CapabilityEditingSupport.this.capabilityContent;
                    }
                };
                break;
            }
        }
    }

    protected CellEditor getCellEditor(Object element) {
        return this.editor;
    }

    protected boolean canEdit(Object element) {
        switch (this.column) {
            case 0: {
                return true;
            }
        }
        return false;
    }

    protected Object getValue(Object element) {
        if (!(element instanceof Capability)) {
            return null;
        }
        Capability capability = (Capability)element;
        switch (this.column) {
            case 0: {
                String name = capability.getContent();
                int index = 0;
                while (index < WebConstant.ACCOUNT_CAPABILITY_TYPES.length) {
                    if (name.equals(WebConstant.ACCOUNT_CAPABILITY_TYPES[index])) {
                        return index;
                    }
                    ++index;
                }
                return -1;
            }
        }
        return null;
    }

    protected void setValue(Object element, Object value) {
        if (!(element instanceof Capability)) {
            return;
        }
        Capability capability = (Capability)element;
        switch (this.column) {
            case 0: {
                capability.setContent((String)value);
                break;
            }
        }
        this.getViewer().update(element, null);
        if (this.getListener() != null) {
            this.getListener().notifyChange();
        }
    }

    public void setListener(AbstractChangeListener listener) {
        this.listener = listener;
    }

    public void unsetListener() {
        this.listener = null;
    }

    public AbstractChangeListener getListener() {
        return this.listener;
    }
}

