/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.jshint.engine;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.tizen.web.jshint.engine.JsHint;

public class JsHintBuilder {
    private static final String HINT_FILE = "lib/jshint.js";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private ContextFactory contextFactory = new ContextFactory();

    public JsHint fromClasspathResource(String resource) throws IOException {
        return this.fromClasspathResource(resource, UTF8);
    }

    public JsHint fromClasspathResource(String resource, Charset encoding) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(resource), encoding));
        return this.fromReader(reader, resource);
    }

    public JsHint fromDefault() {
        try {
            return this.fromClasspathResource(HINT_FILE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public JsHint fromFile(File f) throws IOException {
        return this.fromFile(f, UTF8);
    }

    public JsHint fromFile(File f, Charset encoding) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), encoding));
        return this.fromReader(reader, f.toString());
    }

    public JsHint fromReader(Reader reader, String name) throws IOException {
        try {
            Context cx = this.contextFactory.enterContext();
            ScriptableObject scope = cx.initStandardObjects();
            cx.evaluateReader((Scriptable)scope, reader, name, 1, null);
            Function lintFunc = (Function)scope.get("JSHINT", (Scriptable)scope);
            JsHint jsHint = new JsHint(this.contextFactory, lintFunc);
            return jsHint;
        }
        finally {
            Context.exit();
        }
    }
}

