/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.wizard.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.StringUtil;
import org.tizen.web.apptemplate.model.DependsElement;
import org.tizen.web.apptemplate.model.LibraryElement;
import org.tizen.web.apptemplate.model.TizenTemplateKindsOfLibraries;
import org.tizen.web.apptemplate.model.TizenTemplateLibraryType;
import org.tizen.web.project.wizard.model.TizenTemplateLibrariesPool;

public class TizenTemplateLibraryGroup {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static String ORIGINAL_DIRECTORY = "/original";
    private static String MINIFIED_DIRECTORY = "/minified";
    private String name;
    private String key;
    private List<LibraryElement> libraryList;
    private LibraryElement selectedElement;
    private Map<String, Boolean> selectedMinified;
    private Map<String, String> libraryPath;
    private TizenTemplateLibrariesPool pool;
    Comparator<LibraryElement> comparator = new Comparator<LibraryElement>(){

        @Override
        public int compare(LibraryElement arg0, LibraryElement arg1) {
            if (arg0 == null || arg1 == null) {
                return 0;
            }
            if (arg0.getVersion() == null || arg1.getVersion() == null) {
                return 0;
            }
            return arg1.getVersion().compareTo(arg0.getVersion());
        }
    };

    public TizenTemplateLibraryGroup(TizenTemplateLibrariesPool pool, LibraryElement libElement, String libraryRootPath) {
        assert (libElement != null) : "LibraryElement must not be null!";
        this.pool = pool;
        this.name = libElement.getName();
        this.key = libElement.getKey();
        this.selectedMinified = new HashMap<String, Boolean>();
        this.libraryPath = new HashMap<String, String>();
        this.addLibraryElement(libElement, libraryRootPath);
    }

    public LibraryElement getSelectedElement() {
        assert (this.selectedElement != null) : "selectedElement must not be null!";
        return this.selectedElement;
    }

    public String getSelectedElementValue() {
        LibraryElement element = this.getSelectedElement();
        if (this.isSelectedMinified()) {
            return element.getMinifiedValue();
        }
        return element.getOriginalValue();
    }

    public String getSelectedElementName() {
        LibraryElement element = this.getSelectedElement();
        return element.getName();
    }

    public String getSelectedElementKey() {
        LibraryElement element = this.getSelectedElement();
        return element.getKey();
    }

    public void setSelectedElement(String version) {
        for (LibraryElement libElement : this.libraryList) {
            if (!libElement.getVersion().equals(version)) continue;
            this.selectedElement = libElement;
            return;
        }
    }

    public void setSelectedElementWithDependsUpdate(String version) {
        this.setSelectedElementWithDependsUpdate(version, new PreventCircleReference());
    }

    public void setSelectedElementWithDependsUpdate(String version, PreventCircleReference preventCircleReference) {
        if (preventCircleReference == null || preventCircleReference.isDuplicate(this.name)) {
            this.logger.warn("setSelectedElement: Detected circle reference on the way 'library depends processing'");
            return;
        }
        this.setSelectedElement(version);
        for (DependsElement dependsElement : this.selectedElement.getDepends()) {
            TizenTemplateLibraryGroup group;
            String dependsVersion = dependsElement.getVersion();
            if (StringUtil.isEmpty((CharSequence)dependsVersion) || (group = this.pool.getLibraryGroup(dependsElement.getName())) == null) continue;
            group.setSelectedElementWithDependsUpdate(dependsVersion, preventCircleReference);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isSelectedMinified() {
        String version = this.getSelectedElement().getVersion();
        return this.selectedMinified.get(version);
    }

    public boolean isTizenWebUIFW() {
        LibraryElement libElement = this.getSelectedElement();
        return libElement.getKindsOfLibrary() == TizenTemplateKindsOfLibraries.TIZENWEBUIFW;
    }

    public boolean setSelectedMinified(boolean isSelected) {
        LibraryElement libElement = this.getSelectedElement();
        switch (libElement.getSupportLibraryType()) {
            case MINIFIED: {
                if (!isSelected) {
                    return false;
                }
            }
            case ORIGINAL: {
                if (!isSelected) break;
                return false;
            }
            case BOTH: {
                break;
            }
            default: {
                return false;
            }
        }
        String version = libElement.getVersion();
        Boolean selectState = isSelected ? Boolean.TRUE : Boolean.FALSE;
        this.selectedMinified.put(version, selectState);
        return true;
    }

    public void setSelectedMinifiedWithDependsUpdate(boolean isSelected) {
        this.setSelectedMinifiedWithDependsUpdate(isSelected, new PreventCircleReference());
    }

    public void setSelectedMinifiedWithDependsUpdate(boolean isSelected, PreventCircleReference preventCircleReference) {
        if (preventCircleReference == null || preventCircleReference.isDuplicate(this.name)) {
            this.logger.warn("setSelectedMinified: Detected circle reference on the way 'library depends processing'");
            return;
        }
        this.setSelectedMinified(isSelected);
        for (DependsElement dependsElement : this.selectedElement.getDepends()) {
            TizenTemplateLibraryGroup group = this.pool.getLibraryGroup(dependsElement.getName());
            if (group == null) continue;
            group.setSelectedMinifiedWithDependsUpdate(isSelected, preventCircleReference);
        }
    }

    public String getLibraryPath(String version) {
        return this.libraryPath.get(version);
    }

    public String getSelectedLibraryPath() {
        LibraryElement element = this.getSelectedElement();
        String version = element.getVersion();
        if (version == null) {
            return null;
        }
        String path = this.getLibraryPath(version);
        if (path == null) {
            return null;
        }
        if (this.isTizenWebUIFW()) {
            String addPath = "";
            switch (element.getSupportLibraryType()) {
                case BOTH: {
                    addPath = "/" + (this.isSelectedMinified() ? element.getOriginalValue() : element.getMinifiedValue());
                    break;
                }
            }
            return String.valueOf(path) + addPath;
        }
        return String.valueOf(path) + (this.isSelectedMinified() ? MINIFIED_DIRECTORY : ORIGINAL_DIRECTORY);
    }

    public boolean addLibraryElement(LibraryElement libElement, String libraryRootPath) {
        String location;
        if (libElement == null) {
            return false;
        }
        if (this.libraryList == null) {
            this.libraryList = new ArrayList<LibraryElement>();
            this.selectedElement = libElement;
        }
        TizenTemplateLibraryType libraryType = libElement.getSupportLibraryType();
        String version = libElement.getVersion();
        if (libraryType != null) {
            Boolean canMinified = Boolean.FALSE;
            if (libraryType == TizenTemplateLibraryType.MINIFIED) {
                canMinified = Boolean.TRUE;
            }
            this.selectedMinified.put(version, canMinified);
        }
        if ((location = libElement.getLocation()) != null) {
            this.libraryPath.put(version, String.valueOf(libraryRootPath) + "/" + location);
        }
        return this.libraryList.add(libElement);
    }

    public List<LibraryElement> getLibraryElements() {
        return this.libraryList;
    }

    public void initializeDefaultSelected() {
        Collections.sort(this.libraryList, this.comparator);
        this.setSelectedElement(this.libraryList.get(0).getVersion());
    }

    public List<TizenTemplateLibraryGroup> getDependsGroup() {
        ArrayList<TizenTemplateLibraryGroup> groupList = new ArrayList<TizenTemplateLibraryGroup>();
        if (this.selectedElement == null) {
            return groupList;
        }
        List dependsElementList = this.selectedElement.getDepends();
        if (dependsElementList == null || dependsElementList.isEmpty()) {
            return groupList;
        }
        for (DependsElement dependsElement : dependsElementList) {
            TizenTemplateLibraryGroup group = this.pool.getLibraryGroup(dependsElement.getName());
            if (group == null) {
                return new ArrayList<TizenTemplateLibraryGroup>();
            }
            groupList.add(group);
        }
        return groupList;
    }

    public String getDependsVersion(TizenTemplateLibraryGroup dependsGroup) {
        if (this.selectedElement == null) {
            return null;
        }
        List dependsElementList = this.selectedElement.getDepends();
        if (dependsElementList == null || dependsElementList.isEmpty()) {
            return null;
        }
        for (DependsElement dependsElement : dependsElementList) {
            if (!dependsGroup.getName().equals(dependsElement.getName())) continue;
            return dependsElement.getVersion();
        }
        return null;
    }

    private class PreventCircleReference {
        private List<String> nameList = new ArrayList<String>();

        private PreventCircleReference() {
        }

        public boolean isDuplicate(String name) {
            boolean isResult = this.nameList.contains(name);
            if (!isResult) {
                this.nameList.add(name);
            }
            return isResult;
        }
    }
}

