/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.webwidget.validator.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.CommonPlugin;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.command.Executor;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.OSChecker;
import org.tizen.common.util.StringUtil;
import org.tizen.web.common.WebConstant;
import org.tizen.web.webwidget.validator.core.HtmlCssValidatorCheckHelper;
import org.tizen.web.webwidget.validator.core.ValidatedIssue;
import org.tizen.web.webwidget.validator.util.ValidatorJobHelper;

public class ValidatorUtil {
    protected static final Logger logger = LoggerFactory.getLogger(ValidatorUtil.class);
    static final String WEBWIDGET_VALIDATOR_PATH = String.valueOf(InstallPathConfig.getToolsPath()) + File.separator + "web-widget-validator";
    static final String VALIDATOR_JS_PATH = String.valueOf(WEBWIDGET_VALIDATOR_PATH) + File.separator + "validator.js" + " ";
    static final String VALIDATOR_NODE_COMMAND;
    static final String VALIDATOR_JS_COMMAND;
    static final OStype type;

    static {
        String VALIDATOR_NODE_PATH = String.valueOf(WEBWIDGET_VALIDATOR_PATH) + File.separator + "node";
        if (OSChecker.isWindows()) {
            type = OStype.WIN;
            VALIDATOR_NODE_COMMAND = String.valueOf(VALIDATOR_NODE_PATH) + File.separator + "bin" + File.separator + "node.exe" + " ";
            VALIDATOR_JS_COMMAND = String.valueOf(WEBWIDGET_VALIDATOR_PATH) + File.separator + "run-js-rule-checker.bat" + " ";
        } else if (OSChecker.isLinux() || OSChecker.isMAC()) {
            type = OStype.OTHERS;
            VALIDATOR_NODE_COMMAND = String.valueOf(VALIDATOR_NODE_PATH) + File.separator + "bin" + File.separator + "node" + " ";
            VALIDATOR_JS_COMMAND = String.valueOf(WEBWIDGET_VALIDATOR_PATH) + File.separator + "run-js-rule-checker.sh" + " ";
        } else {
            type = OStype.UNKNOWN;
            VALIDATOR_NODE_COMMAND = "";
            VALIDATOR_JS_COMMAND = "";
        }
    }

    public static String[] getExcludes() throws CoreException {
        ArrayList<String> excludes = new ArrayList<String>();
        excludes.addAll(Arrays.asList(WebConstant.DEFAULT_EXCLUDING_RESOURCES));
        excludes.addAll(Arrays.asList(HtmlCssValidatorCheckHelper.getExcludeFolders()));
        return excludes.toArray(new String[0]);
    }

    public static ValidatedIssue parsingResultMessage(String ResultMessage) {
        String[] fileNameWithLine = ResultMessage.split(":");
        String fileName = fileNameWithLine[0];
        int line = Integer.parseInt(fileNameWithLine[1]);
        String[] columns = fileNameWithLine[2].split(" ");
        int postion = Integer.parseInt(columns[0]);
        char sevirity = columns[1].charAt(0);
        String message = fileNameWithLine[2].substring(fileNameWithLine[2].indexOf(sevirity) + 2, fileNameWithLine[2].length());
        ValidatedIssue vIssue = new ValidatedIssue(fileName, line, postion, sevirity, message);
        return vIssue;
    }

    public static ArrayList<ValidatedIssue> parsingResultMessage(ArrayList<String> ResultMessages) {
        ArrayList<ValidatedIssue> Results = new ArrayList<ValidatedIssue>();
        for (String item : ResultMessages) {
            if (StringUtil.isEmpty((CharSequence)item)) continue;
            Results.add(ValidatorUtil.parsingResultMessage(item));
        }
        return Results;
    }

    public static HashMap<String, ArrayList<ValidatedIssue>> refineResult2Map(ArrayList<ValidatedIssue> parsingResults) {
        HashMap<String, ArrayList<ValidatedIssue>> itemMap = new HashMap<String, ArrayList<ValidatedIssue>>();
        for (ValidatedIssue vIssue : parsingResults) {
            ArrayList<Object> ResultItems;
            String name = vIssue.getFileName();
            if (itemMap.get(name) == null) {
                ResultItems = new ArrayList<ValidatedIssue>();
                ResultItems.add(vIssue);
                itemMap.put(name, ResultItems);
                continue;
            }
            ResultItems = itemMap.get(name);
            ResultItems.add(vIssue);
        }
        return itemMap;
    }

    /*
     * Loose catch block
     * WARNING - bad return control flow
     */
    public static HashMap<String, ArrayList<ValidatedIssue>> executeWithFile(IFile validateFile, IProgressMonitor monitor) {
        HashMap<String, ArrayList<ValidatedIssue>> hashMap;
        ArrayList<String> resultList = null;
        Process p = null;
        if (!ValidatorUtil.isExist(VALIDATOR_NODE_COMMAND)) {
            return null;
        }
        try {
            HashMap<String, ArrayList<ValidatedIssue>> vIssueMap;
            if (type == OStype.UNKNOWN) {
                throw new InterruptedException("Failed to find OS");
            }
            p = Runtime.getRuntime().exec(String.valueOf(VALIDATOR_NODE_COMMAND) + VALIDATOR_JS_PATH + validateFile.getLocation());
            ValidatorJobHelper validatorJobHelper = new ValidatorJobHelper(p, monitor);
            resultList = validatorJobHelper.doValidatorJobs();
            ArrayList<ValidatedIssue> parsingResults = ValidatorUtil.parsingResultMessage(resultList);
            hashMap = vIssueMap = ValidatorUtil.refineResult2Map(parsingResults);
        }
        catch (IOException ioe) {
            logger.error(ioe.getMessage(), (Throwable)ioe);
            IOUtil.tryClose((Object[])new Object[]{p});
        }
        catch (InterruptedException ie) {
            logger.error(ie.getMessage(), (Throwable)ie);
            {
                catch (Throwable throwable) {
                    IOUtil.tryClose((Object[])new Object[]{p});
                    throw throwable;
                }
            }
            IOUtil.tryClose((Object[])new Object[]{p});
        }
        IOUtil.tryClose((Object[])new Object[]{p});
        return hashMap;
        return null;
    }

    private static boolean isExist(String command) {
        if (FileUtil.isExist((String)command.trim())) {
            return true;
        }
        Executor executor = CommonPlugin.getDefault().getExecutor();
        executor.getContext().getPrompter().notify("Please check install version, Can not find: " + command);
        return false;
    }

    /*
     * Loose catch block
     * WARNING - bad return control flow
     */
    public static HashMap<String, ArrayList<ValidatedIssue>> executeWithFolder(IProject project, IProgressMonitor monitor) {
        HashMap<String, ArrayList<ValidatedIssue>> hashMap;
        ArrayList<String> resultList = new ArrayList();
        String projectPath = project.getLocation().toString();
        Process p = null;
        if (!ValidatorUtil.isExist(VALIDATOR_JS_COMMAND)) {
            return null;
        }
        try {
            HashMap<String, ArrayList<ValidatedIssue>> vIssueMap;
            if (type == OStype.UNKNOWN) {
                throw new InterruptedException("Failed to find OS");
            }
            p = Runtime.getRuntime().exec(String.valueOf(VALIDATOR_JS_COMMAND) + InstallPathConfig.getSDKPath() + " " + projectPath);
            ValidatorJobHelper validatorJobHelper = new ValidatorJobHelper(p, monitor);
            resultList = validatorJobHelper.doValidatorJobs();
            resultList = ValidatorUtil.changeMassagefromProjectName(resultList, projectPath);
            ArrayList<ValidatedIssue> parsingResults = ValidatorUtil.parsingResultMessage(resultList);
            hashMap = vIssueMap = ValidatorUtil.refineResult2Map(parsingResults);
        }
        catch (IOException ioe) {
            logger.error(ioe.getMessage(), (Throwable)ioe);
            IOUtil.tryClose((Object[])new Object[]{p});
        }
        catch (InterruptedException ie) {
            logger.error(ie.getMessage(), (Throwable)ie);
            {
                catch (Throwable throwable) {
                    IOUtil.tryClose((Object[])new Object[]{p});
                    throw throwable;
                }
            }
            IOUtil.tryClose((Object[])new Object[]{p});
        }
        IOUtil.tryClose((Object[])new Object[]{p});
        return hashMap;
        return null;
    }

    @Deprecated
    private static ArrayList<String> changeMassagefromProjectName(ArrayList<String> resultList, String projectName) {
        ArrayList<String> removedSeparatorList = new ArrayList<String>();
        for (String s : resultList) {
            if (StringUtil.isEmpty((CharSequence)s)) continue;
            if (s.toLowerCase().contains(projectName.toLowerCase())) {
                removedSeparatorList.add(s.substring(projectName.length(), s.length()));
                continue;
            }
            removedSeparatorList.add(s);
        }
        return removedSeparatorList;
    }

    public static enum OStype {
        WIN("win"),
        OTHERS("others"),
        UNKNOWN("unknown");

        private String type;

        private OStype(String type) {
            this.type = type;
        }
    }
}

