/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.web.common.WebConstant;
import org.tizen.web.config.schema.model.Access;
import org.tizen.web.config.schema.model.Author;
import org.tizen.web.config.schema.model.Content;
import org.tizen.web.config.schema.model.DataBoolean;
import org.tizen.web.config.schema.model.Description;
import org.tizen.web.config.schema.model.Feature;
import org.tizen.web.config.schema.model.Icon;
import org.tizen.web.config.schema.model.License;
import org.tizen.web.config.schema.model.Name;
import org.tizen.web.config.schema.model.Preference;
import org.tizen.web.config.schema.model.Privilege;
import org.tizen.web.config.schema.model.Widget;
import org.tizen.web.editor.configuration.ConfigurationEvent;
import org.tizen.web.editor.configuration.ConfigurationException;
import org.tizen.web.editor.configuration.ConfiguratorFactory;
import org.tizen.web.editor.configuration.IConfigurationListener;
import org.tizen.web.editor.configuration.IW3CConfigurator;
import org.tizen.web.editor.configuration.Messages;
import org.tizen.web.editor.configuration.platform.TizenFeatureReader;
import org.tizen.web.editor.configuration.platform.TizenPrivilegeReader;
import org.tizen.web.editor.configuration.validation.NonSchemaBasedValidator;
import org.tizen.web.editor.configuration.validation.SchemaBasedValidator;
import org.tizen.web.editor.widl.ExternalIDLHandler;
import org.tizen.web.editor.widl.model.Module;
import org.tizen.web.editor.widl.model.PrivilegeWrapper;

public class W3CConfiguratorImpl
implements IW3CConfigurator {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Collection<Feature> knownFeatures;
    protected Collection<PrivilegeWrapper> knownPrivileges;
    protected Collection<PrivilegeWrapper> usedPrivileges;
    protected Collection<Module> availableModules;
    protected Collection<Module> usedModules;
    protected Collection<IConfigurationListener> listeners;
    protected IProject project;
    protected Widget widget;
    protected IFile file;
    protected NonSchemaBasedValidator nonSchemaBasedValidator = new NonSchemaBasedValidator();
    protected SchemaBasedValidator schemaBasedValidator = new SchemaBasedValidator();

    @Override
    public void init(IProject project, Widget root) throws ConfigurationException {
        Assert.isNotNull((Object)project);
        if (!project.isAccessible()) {
            throw new ConfigurationException(Messages.WidgetConfigurator_Project_Error);
        }
        this.project = project;
        this.file = project.getFile("config.xml");
        if (!this.file.isAccessible()) {
            throw new ConfigurationException(Messages.WidgetConfigurator_File_Error);
        }
        this.widget = root;
        TizenFeatureReader tizenFeatureReader = new TizenFeatureReader(project);
        this.knownFeatures = tizenFeatureReader.getFeatures();
        TizenPrivilegeReader tizenPrivilegeReader = new TizenPrivilegeReader(project);
        this.knownPrivileges = tizenPrivilegeReader.getPrivileges();
        Collection<Module> externalModules = ExternalIDLHandler.getInstance().getModules(project);
        this.availableModules = new LinkedList<Module>();
        this.availableModules.addAll(externalModules);
        for (Module module : this.availableModules) {
            String privilegeName = module.getFeatureName();
            if (StringUtil.isEmpty((CharSequence)privilegeName)) continue;
            PrivilegeWrapper privilege = new PrivilegeWrapper(privilegeName);
            if (!this.knownPrivileges.contains(privilege)) {
                this.knownPrivileges.add(privilege);
            }
            Collection<String> subPrivilegeNames = module.getSubfeatureNames();
            for (String subPrivilegeName : subPrivilegeNames) {
                PrivilegeWrapper subPrivilege = new PrivilegeWrapper(subPrivilegeName);
                if (this.knownPrivileges.contains(subPrivilege)) continue;
                this.knownPrivileges.add(subPrivilege);
            }
        }
        HashSet<PrivilegeWrapper> documentPrivileges = new HashSet<PrivilegeWrapper>();
        List<Privilege> privilegeElements = this.getPrivileges();
        for (Privilege privilege : privilegeElements) {
            if (privilege.getName() == null) continue;
            PrivilegeWrapper privilegeWrapper = new PrivilegeWrapper(privilege);
            documentPrivileges.add(privilegeWrapper);
        }
        this.usedPrivileges = new LinkedList<PrivilegeWrapper>(documentPrivileges);
        this.usedModules = new HashSet<Module>();
        for (Module module : this.availableModules) {
            String modulePrivilegeName = module.getFeatureName();
            Collection<String> moduleSubPrivilegeNames = module.getSubfeatureNames();
            for (PrivilegeWrapper privilege : this.usedPrivileges) {
                if (!privilege.getName().equals(modulePrivilegeName) && !moduleSubPrivilegeNames.contains(privilege.getName())) continue;
                this.usedModules.add(module);
            }
        }
        this.listeners = new LinkedList<IConfigurationListener>();
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public Widget getWidget() {
        return this.widget;
    }

    @Override
    public List<Object> getContents() {
        return this.widget.getContent();
    }

    @Override
    public Map<QName, String> getOtherAttributes() {
        return this.widget.getOtherAttributes();
    }

    @Override
    public boolean addElement(Object element) {
        return this.getContents().add(element);
    }

    @Override
    public boolean removeElement(Object element) {
        return this.getContents().remove(element);
    }

    @Override
    public String getLang() {
        return this.widget.getLang();
    }

    @Override
    public void setLang(String value) {
        this.widget.setLang(value);
    }

    @Override
    public String getId() {
        return this.widget.getId();
    }

    @Override
    public void setId(String value) {
        if (StringUtil.isEmpty((CharSequence)value)) {
            this.widget.setId(null);
        } else {
            this.widget.setId(value);
        }
    }

    @Override
    public String getVersion() {
        return this.widget.getVersion();
    }

    @Override
    public void setVersion(String value) {
        if (StringUtil.isEmpty((CharSequence)value)) {
            this.widget.setVersion(null);
        } else {
            this.widget.setVersion(value);
        }
    }

    @Override
    public String getHeight() {
        return this.widget.getHeight();
    }

    @Override
    public void setHeight(String value) {
        this.widget.setHeight(value);
    }

    @Override
    public String getWidth() {
        return this.widget.getWidth();
    }

    @Override
    public void setWidth(String value) {
        this.widget.setWidth(value);
    }

    @Override
    public String getViewmode() {
        if (this.widget.getViewmodes().size() > 0) {
            return (String)this.widget.getViewmodes().get(0);
        }
        return WebConstant.VIEWMODES[0];
    }

    @Override
    public void setViewmode(String value) {
        if (this.widget.getViewmodes().size() > 0) {
            this.widget.getViewmodes().remove(0);
        }
        this.widget.getViewmodes().add(0, value);
    }

    @Override
    public Content getContent() {
        List<Object> Elements = this.getContents();
        for (Object element : Elements) {
            if (!(element instanceof Content)) continue;
            return (Content)element;
        }
        return null;
    }

    @Override
    public Icon getIcon() {
        List<Object> Elements = this.getContents();
        for (Object element : Elements) {
            if (!(element instanceof Icon)) continue;
            return (Icon)element;
        }
        return null;
    }

    @Override
    public List<License> getLicenses() {
        ArrayList<License> licenses = new ArrayList<License>();
        List<Object> Elements = this.getContents();
        for (Object element : Elements) {
            if (!(element instanceof License)) continue;
            licenses.add((License)element);
        }
        return licenses;
    }

    @Override
    public List<Name> getNames() {
        ArrayList<Name> names = new ArrayList<Name>();
        List<Object> Elements = this.getContents();
        for (Object element : Elements) {
            if (!(element instanceof Name)) continue;
            names.add((Name)element);
        }
        return names;
    }

    @Override
    public List<Author> getAuthors() {
        ArrayList<Author> authors = new ArrayList<Author>();
        List<Object> Elements = this.getContents();
        for (Object element : Elements) {
            if (!(element instanceof Author)) continue;
            authors.add((Author)element);
        }
        return authors;
    }

    @Override
    public List<Description> getDescriptions() {
        ArrayList<Description> descriptions = new ArrayList<Description>();
        List<Object> Elements = this.getContents();
        for (Object element : Elements) {
            if (!(element instanceof Description)) continue;
            descriptions.add((Description)element);
        }
        return descriptions;
    }

    @Override
    public List<Access> getAccess() {
        ArrayList<Access> access = new ArrayList<Access>();
        List<Object> Elements = this.getContents();
        for (Object element : Elements) {
            if (!(element instanceof Access)) continue;
            access.add((Access)element);
        }
        return access;
    }

    @Override
    public List<Preference> getPreferences() {
        ArrayList<Preference> preferences = new ArrayList<Preference>();
        List<Object> Elements = this.getContents();
        for (Object element : Elements) {
            if (!(element instanceof Preference)) continue;
            preferences.add((Preference)element);
        }
        return preferences;
    }

    @Override
    public List<Feature> getFeatures() {
        ArrayList<Feature> features = new ArrayList<Feature>();
        List<Object> Elements = this.getContents();
        for (Object element : Elements) {
            if (!(element instanceof Feature)) continue;
            features.add((Feature)element);
        }
        return features;
    }

    @Override
    public List<Privilege> getPrivileges() {
        ArrayList<Privilege> privileges = new ArrayList<Privilege>();
        List<Object> Elements = this.getContents();
        for (Object element : Elements) {
            if (!(element instanceof Privilege)) continue;
            privileges.add((Privilege)element);
        }
        return privileges;
    }

    @Override
    public void setContent(String value) {
        Content content = this.getContent();
        if (!StringUtil.isEmpty((CharSequence)value)) {
            if (content == null) {
                content = new Content();
                this.addElement(content);
            }
            content.setSrc(value);
        } else if (content != null) {
            this.removeElement(content);
        }
    }

    @Override
    public String getContentSrc() {
        Content content = this.getContent();
        if (content != null) {
            return content.getSrc();
        }
        return null;
    }

    @Override
    public void setIcon(String src) {
        Icon icon = this.getIcon();
        if (!StringUtil.isEmpty((CharSequence)src)) {
            if (icon == null) {
                icon = new Icon();
                this.addElement(icon);
            }
            icon.setSrc(src);
        } else if (icon != null) {
            this.removeElement(icon);
        }
    }

    @Override
    public String getIconSrc() {
        Icon icon = this.getIcon();
        if (icon != null) {
            return icon.getSrc();
        }
        return null;
    }

    @Override
    public void setAuthor(String content, String href, String email) {
        List<Author> authors = this.getAuthors();
        if (!authors.isEmpty()) {
            this.removeElement(authors.get(0));
        }
        if (StringUtil.isEmpty((CharSequence)content) && StringUtil.isEmpty((CharSequence)href) && StringUtil.isEmpty((CharSequence)email)) {
            return;
        }
        Author author = new Author();
        this.addElement(author);
        if (!StringUtil.isEmpty((CharSequence)content)) {
            author.getContent().add(content);
        }
        if (!StringUtil.isEmpty((CharSequence)href)) {
            author.setHref(href);
        }
        if (!StringUtil.isEmpty((CharSequence)email)) {
            author.setEmail(email);
        }
    }

    @Override
    public String getAuthorContent() {
        Author author;
        List<Author> authors = this.getAuthors();
        if (!authors.isEmpty() && (author = authors.get(0)) != null && !author.getContent().isEmpty()) {
            return (String)author.getContent().get(0);
        }
        return null;
    }

    @Override
    public String getAuthorEmail() {
        Author author;
        List<Author> authors = this.getAuthors();
        if (!authors.isEmpty() && (author = authors.get(0)) != null) {
            return author.getEmail();
        }
        return null;
    }

    @Override
    public String getAuthorHref() {
        Author author;
        List<Author> authors = this.getAuthors();
        if (!authors.isEmpty() && (author = authors.get(0)) != null) {
            return author.getHref();
        }
        return null;
    }

    @Override
    public void setFeature(String name) {
        if (StringUtil.isEmpty((CharSequence)name)) {
            return;
        }
        Feature feature = new Feature();
        feature.setName(name);
        this.addElement(feature);
    }

    @Override
    public void removeFeature(Feature feature) {
        List<Feature> features = this.getFeatures();
        for (Feature docFeature : features) {
            String name = docFeature.getName();
            if (!name.equals(feature.getName())) continue;
            this.removeElement(feature);
        }
    }

    @Override
    public void setAccess(String uri, DataBoolean subDomains) {
        Access access = new Access();
        access.setOrigin(uri);
        access.setSubdomains(subDomains.value());
        this.addElement(access);
    }

    @Override
    public void removeAllAccess() {
        List<Access> accesses = this.getAccess();
        for (Access access : accesses) {
            this.removeElement(access);
        }
    }

    @Override
    public void setPreference(String name, String value, DataBoolean isReadOnly) {
        Preference preference = new Preference();
        preference.setName(name);
        preference.setValue(value);
        preference.setReadonly(isReadOnly.value());
        this.addElement(preference);
    }

    @Override
    public void removeAllPreferences() {
        List<Preference> preferences = this.getPreferences();
        for (Preference preference : preferences) {
            this.removeElement(preference);
        }
    }

    @Override
    public void setDescription(String content, String lang) {
        List<Description> descriptions = this.getDescriptions();
        for (Description description : descriptions) {
            if (description.getLang() == null && lang == null) {
                this.removeElement(description);
                break;
            }
            if (!description.getLang().equalsIgnoreCase(lang)) continue;
            this.removeElement(description);
            break;
        }
        if (!StringUtil.isEmpty((CharSequence)content)) {
            Description description;
            description = new Description();
            description.getContent().add(content);
            description.setLang(lang);
            this.addElement(description);
        }
    }

    @Override
    public String getDescription(String lang) {
        List<Description> descriptions = this.getDescriptions();
        for (Description description : descriptions) {
            if (description.getLang() == null && lang == null) {
                return (String)description.getContent().get(0);
            }
            if (!description.getLang().equalsIgnoreCase(lang)) continue;
            return (String)description.getContent().get(0);
        }
        return null;
    }

    @Override
    public List<Description> getDescriptions(boolean localed) {
        ArrayList<Description> descriptions = new ArrayList<Description>();
        if (localed) {
            for (Description description : this.getDescriptions()) {
                if (description.getLang() == null) continue;
                descriptions.add(description);
            }
        } else {
            for (Description description : this.getDescriptions()) {
                if (description.getLang() != null) continue;
                descriptions.add(description);
            }
        }
        return descriptions;
    }

    @Override
    public void removeAllDescriptions(boolean localed) {
        List<Description> descriptions = this.getDescriptions();
        if (localed) {
            for (Description description : descriptions) {
                if (description.getLang() == null) continue;
                this.removeElement(description);
            }
        } else {
            for (Description description : descriptions) {
                if (description.getLang() != null) continue;
                this.removeElement(description);
            }
        }
    }

    @Override
    public void setLicense(String content, String href, String lang) {
        List<License> licenses = this.getLicenses();
        for (License license : licenses) {
            if (license.getLang() == null && lang == null) {
                this.removeElement(license);
                break;
            }
            if (!license.getLang().equalsIgnoreCase(lang)) continue;
            this.removeElement(license);
            break;
        }
        if (!StringUtil.isEmpty((CharSequence)content)) {
            License license;
            license = new License();
            license.getContent().add(content);
            license.setLang(lang);
            if (!StringUtil.isEmpty((CharSequence)href)) {
                license.setHref(href);
            }
            this.addElement(license);
        }
    }

    @Override
    public List<License> getLicenses(boolean localed) {
        ArrayList<License> licenses = new ArrayList<License>();
        if (localed) {
            for (License license : this.getLicenses()) {
                if (license.getLang() == null) continue;
                licenses.add(license);
            }
        } else {
            for (License license : this.getLicenses()) {
                if (license.getLang() != null) continue;
                licenses.add(license);
            }
        }
        return licenses;
    }

    @Override
    public String getLicenseHref(String lang) {
        List<License> licenses = this.getLicenses();
        for (License license : licenses) {
            if (license.getLang() == null && lang == null) {
                return license.getHref();
            }
            if (!license.getLang().equalsIgnoreCase(lang)) continue;
            return license.getHref();
        }
        return null;
    }

    @Override
    public String getLicenseContent(String lang) {
        List<License> licenses = this.getLicenses();
        for (License license : licenses) {
            if (license.getLang() == null && lang == null) {
                return (String)license.getContent().get(0);
            }
            if (!license.getLang().equalsIgnoreCase(lang)) continue;
            return (String)license.getContent().get(0);
        }
        return null;
    }

    @Override
    public void removeAllLicenses(boolean localed) {
        List<License> licenses = this.getLicenses();
        if (localed) {
            for (License license : licenses) {
                if (license.getLang() == null) continue;
                this.removeElement(license);
            }
        } else {
            for (License license : licenses) {
                if (license.getLang() != null) continue;
                this.removeElement(license);
            }
        }
    }

    @Override
    public void setName(String content, String lang) {
        List<Name> names = this.getNames();
        for (Name name : names) {
            if (name.getLang() == null && lang == null) {
                this.removeElement(name);
                break;
            }
            if (!name.getLang().equalsIgnoreCase(lang)) continue;
            this.removeElement(name);
            break;
        }
        if (!StringUtil.isEmpty((CharSequence)content)) {
            Name name;
            name = new Name();
            name.getContent().add(content);
            name.setLang(lang);
            this.addElement(name);
        }
    }

    @Override
    public String getName(String lang) {
        List<Name> names = this.getNames();
        for (Name name : names) {
            if (name.getLang() == null && lang == null) {
                return (String)name.getContent().get(0);
            }
            if (!name.getLang().equalsIgnoreCase(lang)) continue;
            return (String)name.getContent().get(0);
        }
        return null;
    }

    @Override
    public List<Name> getNames(boolean localed) {
        ArrayList<Name> names = new ArrayList<Name>();
        if (localed) {
            for (Name name : this.getNames()) {
                if (name.getLang() == null) continue;
                names.add(name);
            }
        } else {
            for (Name name : this.getNames()) {
                if (name.getLang() != null) continue;
                names.add(name);
            }
        }
        return names;
    }

    @Override
    public void removeAllNames(boolean localed) {
        List<Name> names = this.getNames();
        if (localed) {
            for (Name name : names) {
                if (name.getLang() == null) continue;
                this.removeElement(name);
            }
        } else {
            for (Name name : names) {
                if (name.getLang() != null) continue;
                this.removeElement(name);
            }
        }
    }

    @Override
    public Collection<PrivilegeWrapper> getUsedPrivileges() {
        return this.usedPrivileges;
    }

    @Override
    public Collection<PrivilegeWrapper> getKnownPrivileges() {
        return this.knownPrivileges;
    }

    @Override
    public Collection<Feature> getKnwonFeatures() {
        return this.knownFeatures;
    }

    @Override
    public Collection<Module> getUsedModules() {
        return this.usedModules;
    }

    @Override
    public PrivilegeWrapper createPrivilege(String name) {
        Privilege privilege = new Privilege();
        privilege.setName(name);
        this.addElement(privilege);
        PrivilegeWrapper privilegeWrapper = new PrivilegeWrapper(privilege);
        this.usedPrivileges.add(privilegeWrapper);
        ConfigurationEvent event = new ConfigurationEvent();
        this.notifyListeners(event);
        return privilegeWrapper;
    }

    @Override
    public void removePrivilege(PrivilegeWrapper privilegeWrapper) {
        List<Privilege> privilegeElements = this.getPrivileges();
        for (Privilege privilege : privilegeElements) {
            String name = privilege.getName();
            if (!name.equals(privilegeWrapper.getName())) continue;
            this.removeElement(privilege);
            break;
        }
        this.usedPrivileges.remove(privilegeWrapper);
        ConfigurationEvent deletionEvent = new ConfigurationEvent();
        this.notifyListeners(deletionEvent);
    }

    @Override
    public void addExternalDefinition(IFile file) {
        Collection<Module> newModules = ExternalIDLHandler.getInstance().scanDocument(file);
        this.availableModules.addAll(newModules);
        for (Module module : newModules) {
            String privilegeName = module.getFeatureName();
            if (StringUtil.isEmpty((CharSequence)privilegeName)) continue;
            PrivilegeWrapper privilege = new PrivilegeWrapper(privilegeName);
            if (!this.knownPrivileges.contains(privilege)) {
                this.knownPrivileges.add(privilege);
                this.createPrivilege(privilege.getName());
            } else if (!this.usedPrivileges.contains(privilege)) {
                this.createPrivilege(privilege.getName());
            }
            Collection<String> subPrivilegeNames = module.getSubfeatureNames();
            for (String subPrivilegeName : subPrivilegeNames) {
                PrivilegeWrapper subPrivilege = new PrivilegeWrapper(subPrivilegeName);
                if (!this.knownPrivileges.contains(subPrivilege)) {
                    this.knownPrivileges.add(subPrivilege);
                    this.createPrivilege(subPrivilege.getName());
                    continue;
                }
                if (this.usedPrivileges.contains(subPrivilege)) continue;
                this.createPrivilege(subPrivilege.getName());
            }
        }
    }

    @Override
    public void doSave() throws IOException, ConfigurationException {
        this.doSave("config.xml");
    }

    @Override
    public void doSave(String path) throws IOException, ConfigurationException {
        FileOutputStream outputStream = null;
        try {
            try {
                IFile tempFile = this.project.getFile(path);
                outputStream = new FileOutputStream(tempFile.getLocation().toFile());
                ConfiguratorFactory.marshalObject(this.file.getProject(), this.getWidget(), outputStream);
            }
            catch (FileNotFoundException e) {
                throw new ConfigurationException(e);
            }
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{outputStream});
            try {
                IFile configFile = this.project.getFile("config.xml");
                SWTUtil.refreshLocal((IFile)configFile, (int)2);
            }
            catch (CoreException e) {
                throw new ConfigurationException(e);
            }
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{outputStream});
        try {
            IFile configFile = this.project.getFile("config.xml");
            SWTUtil.refreshLocal((IFile)configFile, (int)2);
        }
        catch (CoreException e) {
            throw new ConfigurationException(e);
        }
        this.validate();
    }

    @Override
    public void validate() {
        this.nonSchemaBasedValidator.validateConfigurationDocument(this.file);
        this.schemaBasedValidator.validateConfigurationDocument(this.file);
    }

    @Override
    public void addConfigurationListener(IConfigurationListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeConfigurationListener(IConfigurationListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void notifyListeners(ConfigurationEvent event) {
        for (IConfigurationListener listener : this.listeners) {
            listener.configurationChanged(event);
        }
    }
}

