/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.feature.support;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.tizen.web.config.schema.model.Feature;
import org.tizen.web.editor.configuration.ITizenConfigurator;

public class AddFeaturePage
extends WizardPage {
    private ITizenConfigurator configurator;
    private Text internalsFilterText;
    private Table internalsTable;
    private String[] internalsAvailableFeatureLists;
    private int width = 30;
    private int height = 10;

    protected AddFeaturePage(String pageName, ITizenConfigurator config) {
        super(pageName);
        this.setPageComplete(false);
        this.configurator = config;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout fileLayout = new GridLayout();
        fileLayout.numColumns = 1;
        composite.setLayout((Layout)fileLayout);
        composite.setLayoutData((Object)new GridData(768));
        this.internalsFilterText = new Text(composite, 2048);
        this.internalsFilterText.setLayoutData((Object)new GridData(768));
        this.internalsTable = new Table(composite, 2848);
        GridData data = new GridData();
        data.widthHint = this.convertWidthInCharsToPixels(this.width);
        data.heightHint = this.convertHeightInCharsToPixels(this.height);
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.internalsTable.setLayoutData((Object)data);
        this.internalsFilterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddFeaturePage.this.internalsTable.removeAll();
                String strfilter = AddFeaturePage.this.internalsFilterText.getText().trim();
                if (strfilter.isEmpty()) {
                    int i = 0;
                    while (i < AddFeaturePage.this.internalsAvailableFeatureLists.length) {
                        TableItem item = new TableItem(AddFeaturePage.this.internalsTable, 0);
                        item.setText(AddFeaturePage.this.internalsAvailableFeatureLists[i]);
                        ++i;
                    }
                    return;
                }
                String[] stringArray = AddFeaturePage.this.internalsAvailableFeatureLists;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String featureName = stringArray[n2];
                    if (featureName.contains(strfilter)) {
                        TableItem item = new TableItem(AddFeaturePage.this.internalsTable, 0);
                        item.setText(featureName);
                    }
                    ++n2;
                }
            }
        });
        HashSet<String> availableFeatureNames = new HashSet<String>();
        for (Feature feature : this.configurator.getKnwonFeatures()) {
            availableFeatureNames.add(feature.getName());
        }
        for (Feature feature : this.configurator.getFeatures()) {
            availableFeatureNames.remove(feature.getName());
        }
        if (!availableFeatureNames.isEmpty()) {
            this.internalsAvailableFeatureLists = availableFeatureNames.toArray(new String[availableFeatureNames.size()]);
            Arrays.sort(this.internalsAvailableFeatureLists, 0, this.internalsAvailableFeatureLists.length, String.CASE_INSENSITIVE_ORDER);
            int i = 0;
            while (i < this.internalsAvailableFeatureLists.length) {
                TableItem item = new TableItem(this.internalsTable, 0);
                item.setText(this.internalsAvailableFeatureLists[i]);
                ++i;
            }
        } else {
            this.internalsFilterText.setEnabled(false);
            this.internalsTable.setEnabled(false);
        }
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
        this.setPageComplete(true);
    }

    public TableItem[] getInternalFeatureNames() {
        return this.internalsTable.getItems();
    }
}

