/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.preference;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.IOUtil;
import org.tizen.web.zimlaunch.Activator;
import org.tizen.web.zimlaunch.preference.Messages;

public class LaunchPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private IPreferenceStore store;
    public static final String IGNORE_CONFIG_ERROR_KEY = "IGNORE_CONFIG_ERROR";
    public static final String OPTION_ENABLE_KEY = "OPTION_ENABLE";
    public static final String QUERY_FIELD_KEY = "QUERY_COMMAND";
    public static final String INSTALL_FIELD_KEY = "INSTALL_COMMAND";
    public static final String UNINSTALL_FIELD_KEY = "UNINSTALL_COMMAND";
    public static final String RUN_LAUNCH_FIELD_KEY = "RUN_LAUNCH_COMMAND";
    public static final String WIDGET_LAUNCH_FIELD_KEY = "WIDGET_LAUNCH_COMMAND";
    public static final String DEBUG_LAUNCH_FIELD_KEY = "DEBUG_LAUNCH_COMMAND";
    public static final String KILL_FIELD_KEY = "KILL_COMMAND";
    public static final String RUN_CHECK_FIELD_KEY = "RUN_CHECK_COMMAND";
    private Button optionEnableButton;
    private Button ignoreErrorButton;
    private Group commandComposite;
    private StringFieldEditor queryCommandField;
    private StringFieldEditor installCommandField;
    private StringFieldEditor uninstallCommandField;
    private StringFieldEditor runLaunchCommandField;
    private StringFieldEditor debugLaunchCommandField;
    private StringFieldEditor killCommandField;
    private StringFieldEditor runningCheckCommandField;

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }

    public LaunchPreferencePage() {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.store = this.getPreferenceStore();
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        composite.setLayoutData((Object)gridData);
        this.createIgnoreErrorButton(composite);
        this.createOptionEnableButton(composite);
        this.createCommandOptions(composite);
        this.optionButtonHandle();
        return composite;
    }

    private void createIgnoreErrorButton(Composite composite) {
        this.ignoreErrorButton = new Button(composite, 16416);
        this.ignoreErrorButton.setText(Messages.IGNORE_BUTTON_TEXT);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.ignoreErrorButton.setLayoutData((Object)gridData);
        this.ignoreErrorButton.setFont(composite.getFont());
        this.ignoreErrorButton.setSelection(this.store.getBoolean(IGNORE_CONFIG_ERROR_KEY));
    }

    private void createOptionEnableButton(Composite composite) {
        this.optionEnableButton = new Button(composite, 16416);
        this.optionEnableButton.setText(Messages.OPTION_BUTTON_TEXT);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.optionEnableButton.setLayoutData((Object)gridData);
        this.optionEnableButton.setFont(composite.getFont());
        this.optionEnableButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LaunchPreferencePage.this.optionButtonHandle();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.optionEnableButton.setSelection(this.store.getBoolean(OPTION_ENABLE_KEY));
    }

    private void optionButtonHandle() {
        if (this.optionEnableButton.getSelection()) {
            this.disableAllOverridingCommands();
        } else {
            this.enableAllOverridingCommands();
        }
    }

    private void createCommandOptions(Composite composite) {
        this.commandComposite = new Group(composite, 0);
        this.commandComposite.setText("Commands");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = false;
        this.commandComposite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        this.commandComposite.setLayoutData((Object)gridData);
        this.queryCommandField = new StringFieldEditor(QUERY_FIELD_KEY, "Query:", (Composite)this.commandComposite);
        this.queryCommandField.fillIntoGrid((Composite)this.commandComposite, 2);
        this.queryCommandField.setStringValue(this.store.getString(QUERY_FIELD_KEY));
        this.installCommandField = new StringFieldEditor(INSTALL_FIELD_KEY, "Install:", (Composite)this.commandComposite);
        this.installCommandField.fillIntoGrid((Composite)this.commandComposite, 2);
        this.installCommandField.setStringValue(this.store.getString(INSTALL_FIELD_KEY));
        this.uninstallCommandField = new StringFieldEditor(UNINSTALL_FIELD_KEY, "UnInstall:", (Composite)this.commandComposite);
        this.uninstallCommandField.fillIntoGrid((Composite)this.commandComposite, 2);
        this.uninstallCommandField.setStringValue(this.store.getString(UNINSTALL_FIELD_KEY));
        this.runLaunchCommandField = new StringFieldEditor(RUN_LAUNCH_FIELD_KEY, "Run:", (Composite)this.commandComposite);
        this.runLaunchCommandField.fillIntoGrid((Composite)this.commandComposite, 2);
        this.runLaunchCommandField.setStringValue(this.store.getString(RUN_LAUNCH_FIELD_KEY));
        this.debugLaunchCommandField = new StringFieldEditor(DEBUG_LAUNCH_FIELD_KEY, "Debug:", (Composite)this.commandComposite);
        this.debugLaunchCommandField.fillIntoGrid((Composite)this.commandComposite, 2);
        this.debugLaunchCommandField.setStringValue(this.store.getString(DEBUG_LAUNCH_FIELD_KEY));
        this.killCommandField = new StringFieldEditor(KILL_FIELD_KEY, "Kill:", (Composite)this.commandComposite);
        this.killCommandField.fillIntoGrid((Composite)this.commandComposite, 2);
        this.killCommandField.setStringValue(this.store.getString(KILL_FIELD_KEY));
        this.runningCheckCommandField = new StringFieldEditor(RUN_CHECK_FIELD_KEY, "Run Check:", (Composite)this.commandComposite);
        this.runningCheckCommandField.fillIntoGrid((Composite)this.commandComposite, 2);
        this.runningCheckCommandField.setStringValue(this.store.getString(RUN_CHECK_FIELD_KEY));
    }

    protected void performDefaults() {
        block5: {
            super.performDefaults();
            this.optionEnableButton.setSelection(true);
            this.disableAllOverridingCommands();
            this.ignoreErrorButton.setSelection(false);
            InputStream is = null;
            try {
                try {
                    is = LaunchPreferencePage.class.getClassLoader().getResourceAsStream("resource/LaunchCommand.properties");
                    Properties props = new Properties();
                    props.load(is);
                    this.queryCommandField.setStringValue(props.getProperty(QUERY_FIELD_KEY));
                    this.installCommandField.setStringValue(props.getProperty(INSTALL_FIELD_KEY));
                    this.uninstallCommandField.setStringValue(props.getProperty(UNINSTALL_FIELD_KEY));
                    this.runLaunchCommandField.setStringValue(props.getProperty(RUN_LAUNCH_FIELD_KEY));
                    this.debugLaunchCommandField.setStringValue(props.getProperty(DEBUG_LAUNCH_FIELD_KEY));
                    this.killCommandField.setStringValue(props.getProperty(KILL_FIELD_KEY));
                    this.runningCheckCommandField.setStringValue(props.getProperty(RUN_CHECK_FIELD_KEY));
                }
                catch (IOException e) {
                    this.logger.error("Failed to set launch commands", (Throwable)e);
                    IOUtil.tryClose((Object[])new Object[]{is});
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{is});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{is});
        }
    }

    protected void performApply() {
        this.store.setValue(OPTION_ENABLE_KEY, this.optionEnableButton.getSelection());
        this.store.setValue(QUERY_FIELD_KEY, this.queryCommandField.getStringValue());
        this.store.setValue(INSTALL_FIELD_KEY, this.installCommandField.getStringValue());
        this.store.setValue(UNINSTALL_FIELD_KEY, this.uninstallCommandField.getStringValue());
        this.store.setValue(RUN_LAUNCH_FIELD_KEY, this.runLaunchCommandField.getStringValue());
        this.store.setValue(DEBUG_LAUNCH_FIELD_KEY, this.debugLaunchCommandField.getStringValue());
        this.store.setValue(KILL_FIELD_KEY, this.killCommandField.getStringValue());
        this.store.setValue(RUN_CHECK_FIELD_KEY, this.runningCheckCommandField.getStringValue());
        this.store.setValue(IGNORE_CONFIG_ERROR_KEY, this.ignoreErrorButton.getSelection());
    }

    private void enableAllOverridingCommands() {
        this.commandComposite.setEnabled(true);
        this.queryCommandField.setEnabled(true, (Composite)this.commandComposite);
        this.installCommandField.setEnabled(true, (Composite)this.commandComposite);
        this.uninstallCommandField.setEnabled(true, (Composite)this.commandComposite);
        this.runLaunchCommandField.setEnabled(true, (Composite)this.commandComposite);
        this.debugLaunchCommandField.setEnabled(true, (Composite)this.commandComposite);
        this.killCommandField.setEnabled(true, (Composite)this.commandComposite);
        this.runningCheckCommandField.setEnabled(true, (Composite)this.commandComposite);
    }

    private void disableAllOverridingCommands() {
        this.commandComposite.setEnabled(false);
        this.queryCommandField.setEnabled(false, (Composite)this.commandComposite);
        this.installCommandField.setEnabled(false, (Composite)this.commandComposite);
        this.uninstallCommandField.setEnabled(false, (Composite)this.commandComposite);
        this.runLaunchCommandField.setEnabled(false, (Composite)this.commandComposite);
        this.debugLaunchCommandField.setEnabled(false, (Composite)this.commandComposite);
        this.killCommandField.setEnabled(false, (Composite)this.commandComposite);
        this.runningCheckCommandField.setEnabled(false, (Composite)this.commandComposite);
    }
}

