/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.step;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.osgi.util.NLS;
import org.tizen.common.launch.context.ILaunchContext;
import org.tizen.common.util.DialogUtil;
import org.tizen.web.zimlaunch.core.CompositeStep;
import org.tizen.web.zimlaunch.exception.TizenWebIDEException;
import org.tizen.web.zimlaunch.exception.TizenWebIDEExceptionCode;
import org.tizen.web.zimlaunch.notification.TizenWebNotifier;
import org.tizen.web.zimlaunch.resource.ZimLaunchResource;
import org.tizen.web.zimlaunch.step.Messages;
import org.tizen.web.zimlaunch.step.TransferStep;
import org.tizen.web.zimlaunch.util.CommandLauncher;

public class ConfirmSkipUpLoadStep
extends CompositeStep {
    public static final String name = Messages.STEP_SKIP_UPLOAD;
    protected ILaunchConfiguration config;
    protected CommandLauncher launcher;
    protected ZimLaunchResource resource;
    protected TizenWebNotifier notifier;
    protected boolean isInstalled;
    protected boolean skipUpload;
    protected int percent;

    public ConfirmSkipUpLoadStep(TransferStep transferStep) {
        super(transferStep);
        this.work = 100;
        this.rwork = 100;
        this.percent = 10;
    }

    @Override
    public void executeStep(ILaunchContext ctx) throws Exception {
        this.preExecuteStep(ctx);
        String errMsg = "";
        int code = 0;
        this.notifier.notifyContents("Confirm skip upload option : " + this.skipUpload, this.getWorkCount(40));
        if (this.skipUpload) {
            if (!this.isInstalled) {
                int ret = DialogUtil.openQuestionDialog((String)Messages.STEP_SKIP_UPLOAD_QUESTIONS);
                if (ret == 64) {
                    this.notifier.notifyContents("Confirm skip upload option success", this.getWorkCount(30));
                    super.executeStep(ctx);
                    return;
                }
                if (ret != 64) {
                    code = TizenWebIDEExceptionCode.WEB_IDE_STEPSKIPUPLOAD_FAIL.getCode();
                    errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)Messages.STEP_SKIP_UPLOAD);
                    TizenWebIDEException.abort(Messages.STEP_SKIP_UPLOAD_FAILED, new TizenWebIDEException(errMsg, code), this.notifier);
                }
            }
            this.notifier.notifyContents("Confirm skip upload option success", this.getWorkCount(30));
            return;
        }
        this.notifier.notifyContents("Confirm skip upload option success", this.getWorkCount(100));
        super.executeStep(ctx);
    }

    protected void preExecuteStep(ILaunchContext ctx) throws Exception {
        String errMsg = "";
        int code = 0;
        this.config = (ILaunchConfiguration)ctx.getValue((Object)"config");
        String eMsg = Messages.getFailMessage((String)Messages.TRANSFER_PACKAGE);
        if (this.config == null) {
            code = TizenWebIDEExceptionCode.WEB_IDE_STEPCONTEXT_CAN_NOT_FIND_CONFIG.getCode();
            errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)Messages.STEP_CONTEXT_HANDLE);
            TizenWebIDEException.abort(eMsg, new TizenWebIDEException(errMsg, code), new TizenWebNotifier[0]);
        }
        this.launcher = (CommandLauncher)ctx.getValue((Object)"command launcher");
        if (this.launcher == null) {
            code = TizenWebIDEExceptionCode.WEB_IDE_STEPCONTEXT_CAN_NOT_FIND_COMMNAD_LAUNCHER.getCode();
            errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)Messages.STEP_CONTEXT_HANDLE);
            TizenWebIDEException.abort(eMsg, new TizenWebIDEException(errMsg, code), new TizenWebNotifier[0]);
        }
        this.resource = (ZimLaunchResource)ctx.getValue((Object)"resource");
        if (this.resource == null) {
            code = TizenWebIDEExceptionCode.WEB_IDE_STEPCONTEXT_CAN_NOT_FIND_LAUNCH_RESOURCE.getCode();
            errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)Messages.STEP_CONTEXT_HANDLE);
            TizenWebIDEException.abort(eMsg, new TizenWebIDEException(errMsg, code), new TizenWebNotifier[0]);
        }
        this.notifier = (TizenWebNotifier)ctx.getValue((Object)"notifier");
        this.isInstalled = (Boolean)ctx.getValue((Object)"widget installation");
        this.pwork = this.notifier.getRemainWork() < 20 ? this.notifier.getPercentRemainWork(this.percent) : 10;
    }

    @Override
    public String getStepName() {
        return name;
    }
}

