/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.livereload.servlet;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.CollectionUtil;
import org.tizen.common.util.FilenameUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.IteratingRunner;
import org.tizen.web.livereload.ILiveReloadListener;
import org.tizen.web.livereload.LiveReloadEvent;
import org.tizen.web.livereload.servlet.LiveReloadSocket;
import org.tizen.web.livereload.servlet.WebSocketMessage;

public class LiveReloadSocketManager
implements WebSocketFactory.Acceptor,
Closeable {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final HashSet<LiveReloadSocket> uninitializedSockets = new HashSet();
    protected final HashSet<LiveReloadSocket> sockets = new HashSet();
    protected final ObjectMapper mapper = new ObjectMapper();
    protected final ArrayList<ILiveReloadListener> listeners = new ArrayList();

    public WebSocket doWebSocketConnect(HttpServletRequest req, String protocol) {
        this.logger.trace("Connection requested :{}, {}", (Object)req, (Object)protocol);
        LiveReloadSocket webSocket = new LiveReloadSocket(this);
        return webSocket;
    }

    public boolean checkOrigin(HttpServletRequest req, String protocol) {
        this.logger.trace("Check origin :{}, {}", (Object)req, (Object)protocol);
        return true;
    }

    synchronized void add(LiveReloadSocket socket) {
        this.logger.trace("Socket for livereload: {}", (Object)socket);
        this.uninitializedSockets.add(socket);
        LiveReloadEvent event = new LiveReloadEvent(null, socket, null);
        for (ILiveReloadListener listener : this.listeners) {
            listener.onAccepted(event);
        }
    }

    synchronized void initialize(LiveReloadSocket socket) {
        if (this.uninitializedSockets.remove(socket)) {
            this.sockets.add(socket);
        }
    }

    void remove(LiveReloadSocket socket, String magic) {
        this.sockets.remove(socket);
        LiveReloadEvent event = new LiveReloadEvent(magic, socket, null);
        for (ILiveReloadListener listener : this.listeners) {
            listener.onDisconnect(event);
        }
    }

    public Collection<LiveReloadSocket> getSockets() {
        return Collections.unmodifiableCollection(this.sockets);
    }

    public void reload(String path) throws JsonGenerationException, JsonMappingException, IOException {
        WebSocketMessage message = new WebSocketMessage();
        message.setCommand("reload");
        if (path != null) {
            message.setPath(FilenameUtil.getCanonicalForm((String)path));
        }
        message.setLiveCSS(true);
        message.setLiveJS(true);
        this.broadcast(message);
    }

    public void broadcast(WebSocketMessage message) throws IOException {
        for (LiveReloadSocket socket : this.sockets) {
            socket.send(message);
        }
    }

    public void addListener(ILiveReloadListener listener) {
        this.listeners.add(listener);
        this.logger.info("{} added", (Object)listener);
    }

    public boolean removeListener(ILiveReloadListener listener) {
        boolean bResult = this.listeners.remove(listener);
        this.logger.info("{} removed", (Object)listener);
        return bResult;
    }

    @Override
    public void close() throws IOException {
        try {
            CollectionUtil.iterate(this.sockets, (IteratingRunner)new IteratingRunner<LiveReloadSocket>(){

                public void run(LiveReloadSocket socket) {
                    IOUtil.tryClose((Object[])new Object[]{socket});
                }
            });
            CollectionUtil.iterate(this.uninitializedSockets, (IteratingRunner)new IteratingRunner<LiveReloadSocket>(){

                public void run(LiveReloadSocket socket) {
                    IOUtil.tryClose((Object[])new Object[]{socket});
                }
            });
        }
        catch (InvocationTargetException e) {
            throw new IOException(e.getCause());
        }
    }
}

