/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.wizard.extension;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import json.nature.JsonValidationNature;
import org.eclipse.core.resources.FileInfoMatcherDescription;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceFilterDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.internal.ide.misc.FileInfoAttributesMatcher;
import org.eclipse.wst.css.core.internal.contentproperties.CSSContentProperties;
import org.eclipse.wst.jsdt.web.core.internal.project.JsWebNature;
import org.mihalis.opal.utils.StringUtil;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.util.Assert;
import org.tizen.common.util.EFSUtil;
import org.tizen.common.util.ObjectUtil;
import org.tizen.common.util.PluginUtil;
import org.tizen.common.util.ProjectUtil;
import org.tizen.web.common.WebCommonActivator;
import org.tizen.web.editor.configuration.ConfigurationException;
import org.tizen.web.editor.configuration.ConfiguratorFactory;
import org.tizen.web.editor.configuration.ITizenConfigurator;
import org.tizen.web.project.builder.WebNature;
import org.tizen.web.project.initializer.ProjectJSScopeUtility;
import org.tizen.web.project.initializer.WebLibraryInitializer;
import org.tizen.web.project.wizard.Activator;

public class WebProjectCreator {
    protected static final Logger logger = LoggerFactory.getLogger(WebProjectCreator.class);
    protected static final String DEFAULT_CONFIG_DIR_IN_PLUGIN = new Path("config").append("Tizen").toPortableString();
    protected final int totalTick = 100;
    protected IProject project = null;
    public static final String JSDTValidatorID = "org.eclipse.wst.jsdt.core.javascriptValidator";
    private final int NUMBER_OF_OPERATIONS_FOR_MAKE_A_PROJECT = 7;
    private final int NUMBER_OF_OPERATIONS_FOR_INITIALIZE_A_CONFIGURATION = 2;
    private final int NUMBER_OF_OPERATIONS_FOR_GET_A_CONFIGURATION = 2;
    private final int NUMBER_OF_OPERATIONS_FOR_ADD_NATURES = 5;
    private final int NUMBER_OF_OPERATIONS_FOR_INITIALIZE_LIBRARIES = 2;

    public WebProjectCreator(IProject project) {
        Assert.notNull((Object)project);
        this.project = project;
    }

    public synchronized boolean makeWebProject(IProgressMonitor monitor) {
        monitor = (IProgressMonitor)ObjectUtil.nvl((Object[])new IProgressMonitor[]{monitor, new NullProgressMonitor()});
        monitor.beginTask("Make the web project", 100);
        int tick = 100 / 7;
        try {
            boolean bDesc;
            this.handleMonitorCancel(monitor);
            this.getConfiguration(this.createSubMonitor(monitor, tick));
            this.handleMonitorCancel(monitor);
            this.initializeConfiguration(this.createSubMonitor(monitor, tick));
            this.handleMonitorCancel(monitor);
            this.addNaturesForValidation(this.createSubMonitor(monitor, tick));
            this.handleMonitorCancel(monitor);
            WebNature.addNature((IProject)this.project, null, (IProgressMonitor)this.createSubMonitor(monitor, tick));
            this.handleMonitorCancel(monitor);
            ProfileInfo profileInfo = InstallPathConfig.getLatestProfileInfo();
            if (profileInfo != null && !(bDesc = ProjectUtil.createTizenProjectDescription((IProject)this.project, (ProfileInfo)profileInfo))) {
                logger.warn("Failed to create the Tizen projec description.");
            }
            monitor.worked(tick);
            this.handleMonitorCancel(monitor);
            this.initializeJSLib(this.createSubMonitor(monitor, tick));
            return true;
        }
        catch (URISyntaxException e) {
            logger.error("Failed to process the URI", (Throwable)e);
        }
        catch (CoreException e) {
            logger.error("Failed to process the creation", (Throwable)e);
        }
        catch (ConfigurationException e) {
            logger.error("Failed to process the widget configuration", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Failed to process the resources", (Throwable)e);
        }
        finally {
            monitor.done();
        }
        return false;
    }

    public IResource findConfiguration() {
        return this.project.findMember("config.xml");
    }

    public IResource getConfiguration(IProgressMonitor monitor) throws URISyntaxException, CoreException {
        monitor = (IProgressMonitor)ObjectUtil.nvl((Object[])new IProgressMonitor[]{monitor, new NullProgressMonitor()});
        monitor.beginTask("Get a configuration", 100);
        int tick = 100 / 2;
        IResource config = this.findConfiguration();
        try {
            if (config == null || !config.exists()) {
                URI sourceURI = this.getRealEntry(DEFAULT_CONFIG_DIR_IN_PLUGIN);
                URI destinationURI = this.project.getLocationURI();
                this.handleMonitorCancel(monitor);
                EFSUtil.copy((URI)sourceURI, (URI)destinationURI, (int)2, (IProgressMonitor)this.createSubMonitor(monitor, tick));
                this.handleMonitorCancel(monitor);
                this.project.refreshLocal(1, this.createSubMonitor(monitor, tick));
                config = this.findConfiguration();
            }
        }
        finally {
            monitor.done();
        }
        return config;
    }

    public void initializeConfiguration(IProgressMonitor monitor) throws ConfigurationException, IOException {
        monitor = (IProgressMonitor)ObjectUtil.nvl((Object[])new IProgressMonitor[]{monitor, new NullProgressMonitor()});
        String projectName = this.project.getName();
        String widgetId = String.valueOf(this.getWidgetURI()) + projectName;
        monitor.beginTask("Initialize a configuration", 100);
        int tick = 100 / 2;
        try {
            this.handleMonitorCancel(monitor);
            ITizenConfigurator configurator = ConfiguratorFactory.unmarshalWidgetConfiguration((IProject)this.project);
            monitor.worked(tick);
            this.setWebConfiguration(projectName, widgetId, configurator, monitor);
            configurator.doSave();
            monitor.worked(tick);
        }
        finally {
            monitor.done();
        }
    }

    private void setWebConfiguration(String projectName, String widgetId, ITizenConfigurator configurator, IProgressMonitor monitor) {
        configurator.setId(widgetId);
        configurator.setName(projectName, null);
        TizenProjectDescription description = ProjectUtil.getTizenProjectDescription((IProject)this.project);
        if (description != null) {
            configurator.setProfileName(description.getProfileName());
        }
        String requiredVer = configurator.getApplicationRequiredVersion();
        this.handleMonitorCancel(monitor);
        if (configurator.getApplication() != null) {
            configurator.setApplication(projectName, null, requiredVer);
        } else {
            configurator.setAddon(null, requiredVer);
        }
        configurator.setServiceID(String.valueOf(configurator.getApplicationPackage()) + "." + "Service");
    }

    public void initializeConfigurationForImport(String profile, String version, IProgressMonitor monitor) throws ConfigurationException, IOException {
        monitor = (IProgressMonitor)ObjectUtil.nvl((Object[])new IProgressMonitor[]{monitor, new NullProgressMonitor()});
        monitor.beginTask("Initialize a configuration", 100);
        int tick = 100 / 2;
        try {
            this.handleMonitorCancel(monitor);
            ITizenConfigurator configurator = ConfiguratorFactory.unmarshalWidgetConfiguration((IProject)this.project);
            if (configurator == null) {
                throw new ConfigurationException("\n" + this.project.getName() + "\nFailed to get configuration");
            }
            monitor.worked(tick);
            String appID = configurator.getApplicationAppID();
            String pkgID = configurator.getApplicationPackage();
            String requiredVer = configurator.getApplicationRequiredVersion();
            this.handleMonitorCancel(monitor);
            if (StringUtil.isEmpty((String)appID) || StringUtil.isEmpty((String)pkgID) || StringUtil.isEmpty((String)requiredVer)) {
                configurator.setApplication(configurator.getName(null), pkgID, requiredVer);
            }
            configurator.setProfileName(profile);
            configurator.doSave();
            monitor.worked(tick);
        }
        finally {
            monitor.done();
        }
    }

    public void initializeConfigurationForImport(IProgressMonitor monitor) throws ConfigurationException, IOException {
        monitor = (IProgressMonitor)ObjectUtil.nvl((Object[])new IProgressMonitor[]{monitor, new NullProgressMonitor()});
        monitor.beginTask("Initialize a configuration", 100);
        int tick = 100 / 2;
        try {
            this.handleMonitorCancel(monitor);
            ITizenConfigurator configurator = ConfiguratorFactory.unmarshalWidgetConfiguration((IProject)this.project);
            monitor.worked(tick);
            String appID = configurator.getApplicationAppID();
            String pkgID = configurator.getApplicationPackage();
            String requiredVer = configurator.getApplicationRequiredVersion();
            this.handleMonitorCancel(monitor);
            if (StringUtil.isEmpty((String)appID) || StringUtil.isEmpty((String)pkgID) || StringUtil.isEmpty((String)requiredVer)) {
                configurator.setApplication(configurator.getName(null), pkgID, requiredVer);
                configurator.doSave();
            }
            monitor.worked(tick);
        }
        finally {
            monitor.done();
        }
    }

    public void addNaturesForValidation(IProgressMonitor monitor) throws CoreException {
        monitor = (IProgressMonitor)ObjectUtil.nvl((Object[])new IProgressMonitor[]{monitor, new NullProgressMonitor()});
        monitor.beginTask("Add validation natures", 100);
        int tick = 100 / 5;
        try {
            this.handleMonitorCancel(monitor);
            JsonValidationNature.addNature((IProject)this.project);
            monitor.worked(tick);
            this.handleMonitorCancel(monitor);
            if (this.hasJSLibConfigFile(this.project)) {
                JsWebNature.addJsNature((IProject)this.project, (IProgressMonitor)monitor);
            } else {
                JsWebNature jsNature = new JsWebNature(this.project, this.createSubMonitor(monitor, tick));
                jsNature.configure();
            }
            this.removeBuildCommand(this.project, JSDTValidatorID);
            this.handleMonitorCancel(monitor);
            final IProject finalProject = this.project;
            Job job = new Job("Configuring CSS profile for avoid resource change event"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        if (!finalProject.exists()) {
                            logger.debug("Project is not exists");
                        } else {
                            CSSContentProperties.setProperty((String)"css-profile", (IResource)finalProject, (String)"org.eclipse.wst.css.core.cssprofile.css3");
                        }
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setRule((ISchedulingRule)this.project);
            job.schedule();
            monitor.worked(tick);
        }
        finally {
            monitor.done();
        }
    }

    private boolean hasJSLibConfigFile(IProject project) {
        if (project == null) {
            return false;
        }
        return project.getFolder(".settings").getFile(".jsdtscope").exists();
    }

    public void initializeJSLib(IProgressMonitor monitor, String jQueryVersion) {
        monitor = (IProgressMonitor)ObjectUtil.nvl((Object[])new IProgressMonitor[]{monitor, new NullProgressMonitor()});
        monitor.beginTask("Initialize javascript libraries", 100);
        int tick = 100 / 2;
        try {
            this.handleMonitorCancel(monitor);
            ProjectJSScopeUtility utility = new ProjectJSScopeUtility();
            if (jQueryVersion != null) {
                utility.addGlobalScopeByJqueryVersion(this.project, jQueryVersion, false);
            } else {
                utility.addGlobalScope(this.project);
            }
            monitor.worked(tick);
            this.handleMonitorCancel(monitor);
            WebLibraryInitializer libraryInitializer = new WebLibraryInitializer();
            utility.refreshGlobalScope(this.project, libraryInitializer, libraryInitializer.getPath());
            monitor.worked(tick);
        }
        finally {
            monitor.done();
        }
    }

    public void initializeJSLib(IProgressMonitor monitor) {
        this.initializeJSLib(monitor, null);
    }

    public IPreferenceStore getPreferenceStore() {
        return WebCommonActivator.getDefault().getPreferenceStore();
    }

    public String getWidgetURI() {
        String widgetURI = this.getPreferenceStore().getString("org.tizen.web.common.widget.uri");
        return widgetURI.isEmpty() ? "http://yourdomain/" : widgetURI;
    }

    public IResourceFilterDescription addResourceFilter(String pattern, IProgressMonitor monitor) throws CoreException {
        monitor = (IProgressMonitor)ObjectUtil.nvl((Object[])new IProgressMonitor[]{monitor, new NullProgressMonitor()});
        monitor.beginTask("Add resource filter", 100);
        int tick = 100;
        try {
            int type = 10;
            FileInfoAttributesMatcher.Argument argument = new FileInfoAttributesMatcher.Argument();
            argument.pattern = pattern;
            argument.operator = FileInfoAttributesMatcher.OPERATOR_MATCHES;
            String encodedArgs = FileInfoAttributesMatcher.encodeArguments((FileInfoAttributesMatcher.Argument)argument);
            FileInfoMatcherDescription matcherDescription = new FileInfoMatcherDescription(FileInfoAttributesMatcher.ID, (Object)encodedArgs);
            this.handleMonitorCancel(monitor);
            IResourceFilterDescription iResourceFilterDescription = this.project.createFilter(type, matcherDescription, 128, this.createSubMonitor(monitor, tick));
            return iResourceFilterDescription;
        }
        finally {
            monitor.done();
        }
    }

    public void removeBuildCommand(IProject project, String id) throws CoreException {
        Assert.notNull((Object)project);
        Assert.notNull((Object)id);
        IProjectDescription desc = project.getDescription();
        ICommand[] buildSpec = desc.getBuildSpec();
        ArrayList<ICommand> list = new ArrayList<ICommand>();
        ICommand[] iCommandArray = buildSpec;
        int n = buildSpec.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand cmd = iCommandArray[n2];
            if (!cmd.getBuilderName().equals(id)) {
                list.add(cmd);
            }
            ++n2;
        }
        desc.setBuildSpec(list.toArray(new ICommand[0]));
        project.setDescription(desc, null);
    }

    protected void handleMonitorCancel(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected URI getRealEntry(String path) throws URISyntaxException {
        URL fileURL = PluginUtil.getFileURLinBundle((Bundle)Activator.getDefault().getBundle(), (String)path);
        return fileURL != null ? URIUtil.toURI((URL)fileURL) : null;
    }

    protected IProgressMonitor createSubMonitor(IProgressMonitor parent, int ticks) {
        return new SubProgressMonitor(parent, ticks, 4);
    }
}

