/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.localization;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.tizen.web.config.schema.model.License;
import org.tizen.web.editor.configuration.support.AbstractChangeListener;

public class LicenseEditingSupport
extends EditingSupport {
    private int column;
    private CellEditor editor;
    private AbstractChangeListener listener;
    private static final String EMPTY_STRING = "";

    public LicenseEditingSupport(ColumnViewer viewer, int column) {
        super(viewer);
        this.column = column;
        switch (column) {
            case 0: {
                if (!(viewer instanceof TableViewer)) break;
                this.editor = new TextCellEditor((Composite)((TableViewer)viewer).getTable());
                break;
            }
            case 1: {
                if (!(viewer instanceof TableViewer)) break;
                this.editor = new TextCellEditor((Composite)((TableViewer)viewer).getTable());
                break;
            }
            case 2: {
                if (!(viewer instanceof TableViewer)) break;
                this.editor = new TextCellEditor((Composite)((TableViewer)viewer).getTable());
                break;
            }
        }
    }

    protected CellEditor getCellEditor(Object element) {
        return this.editor;
    }

    protected boolean canEdit(Object element) {
        switch (this.column) {
            case 0: {
                return false;
            }
            case 1: {
                return false;
            }
            case 2: {
                return false;
            }
        }
        return false;
    }

    protected Object getValue(Object element) {
        if (!(element instanceof License)) {
            return null;
        }
        License license = (License)element;
        switch (this.column) {
            case 0: {
                String lang = license.getLang();
                if (lang != null) {
                    return lang;
                }
                return EMPTY_STRING;
            }
            case 1: {
                String name = (String)license.getContent().get(0);
                if (name != null) {
                    return name;
                }
                return EMPTY_STRING;
            }
            case 2: {
                String href = license.getHref();
                if (href != null) {
                    return href;
                }
                return EMPTY_STRING;
            }
        }
        return null;
    }

    protected void setValue(Object element, Object value) {
        if (!(element instanceof License)) {
            return;
        }
        License license = (License)element;
        switch (this.column) {
            case 0: {
                license.setLang((String)value);
                break;
            }
            case 1: {
                license.getContent().add((String)value);
                break;
            }
            case 2: {
                license.setHref((String)value);
                break;
            }
        }
        this.getViewer().update(element, null);
        if (this.getListener() != null) {
            this.getListener().notifyChange();
        }
    }

    public void setListener(AbstractChangeListener listener) {
        this.listener = listener;
    }

    public void unsetListener() {
        this.listener = null;
    }

    public AbstractChangeListener getListener() {
        return this.listener;
    }
}

