/*
 * Decompiled with CFR 0.152.
 */
package io.emmet.eclipse;

import com.google.gson.Gson;
import io.emmet.Emmet;
import io.emmet.IUserData;
import io.emmet.eclipse.EclipseEmmetPlugin;
import io.emmet.eclipse.EclipseTemplateProcessor;
import io.emmet.eclipse.preferences.TemplateHelper;
import io.emmet.eclipse.preferences.output.OutputProfile;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.persistence.TemplateStore;

public class EclipseUserData
implements IUserData {
    @Override
    public void load(Emmet ctx) {
    }

    @Override
    public void loadExtensions(Emmet ctx) {
        File extDir;
        IPreferenceStore store = EclipseEmmetPlugin.getDefault().getPreferenceStore();
        String extensionsPath = store.getString("extensionsPath");
        if (extensionsPath != null && extensionsPath.length() > 0 && (extDir = new File(extensionsPath)).exists() && extDir.isDirectory()) {
            File[] files = extDir.listFiles();
            ArrayList<String> extFiles = new ArrayList<String>();
            try {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    extFiles.add(f.getCanonicalPath());
                    ++n2;
                }
            }
            catch (Exception exception) {}
            Gson gson = new Gson();
            ctx.execJSFunction("javaLoadExtensions", gson.toJson(extFiles));
        }
        HashMap<String, Cloneable> userData = new HashMap<String, Cloneable>();
        userData.put("variables", this.getTemplates("variables"));
        userData.put("snippets", this.getTemplates("snippets"));
        userData.put("abbreviations", this.getTemplates("abbreviations"));
        userData.put("profiles", OutputProfile.allProfiles());
        Gson gson = new Gson();
        String payload = gson.toJson(userData);
        ctx.execJSFunction("javaLoadUserData", payload);
    }

    private ArrayList<ArrayList<String>> getTemplates(String type) {
        TemplateStore storage = this.storeFactory(type);
        Template[] templates = storage.getTemplates();
        ArrayList<ArrayList<String>> output = new ArrayList<ArrayList<String>>();
        Template[] templateArray = templates;
        int n = templates.length;
        int n2 = 0;
        while (n2 < n) {
            Template template = templateArray[n2];
            ArrayList<String> templateItem = new ArrayList<String>();
            String ctxId = template.getContextTypeId();
            if (ctxId.lastIndexOf(46) != -1) {
                String syntax = ctxId.substring(ctxId.lastIndexOf(46) + 1);
                templateItem.add(syntax);
            }
            templateItem.add(template.getName());
            templateItem.add(EclipseTemplateProcessor.process(template.getPattern()));
            output.add(templateItem);
            ++n2;
        }
        return output;
    }

    private TemplateStore storeFactory(String type) {
        if (type.equals("variables")) {
            return TemplateHelper.getVariableStore();
        }
        return TemplateHelper.getTemplateStore(type);
    }

    @Override
    public String[] additionalSourceJS() {
        return null;
    }
}

