/*
 * Decompiled with CFR 0.152.
 */
package json.nature;

import java.util.ArrayList;
import java.util.Arrays;
import json.JsonLog;
import json.nature.Messages;
import json.validation.IncrementalJsonValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class JsonValidationNature
implements IProjectNature {
    public static final String NATURE_ID = "json.validation.nature";
    private IProject project;

    public void configure() throws CoreException {
        IncrementalJsonValidator.addBuilderToProject(this.project);
        new Job("Validating Json Files"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    JsonValidationNature.this.project.build(6, "json.validation.builder", null, monitor);
                }
                catch (CoreException e) {
                    JsonLog.logError(e);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void deconfigure() throws CoreException {
        IncrementalJsonValidator.removeBuilderFromProject(this.project);
        IncrementalJsonValidator.deleteValidationMarkers(this.project);
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public static void addNature(IProject project) {
        String[] natureIds;
        IProjectDescription description;
        if (!project.isOpen()) {
            return;
        }
        try {
            description = project.getDescription();
        }
        catch (CoreException e) {
            JsonLog.logError(Messages.JsonValidationNature_2, e);
            return;
        }
        ArrayList<String> newIds = new ArrayList<String>();
        String[] stringArray = natureIds = description.getNatureIds();
        int n = natureIds.length;
        int n2 = 0;
        while (n2 < n) {
            String natureId = stringArray[n2];
            if (natureId.equals(NATURE_ID)) {
                return;
            }
            ++n2;
        }
        newIds.addAll(Arrays.asList(natureIds));
        newIds.add(NATURE_ID);
        description.setNatureIds(newIds.toArray(new String[newIds.size()]));
        try {
            project.setDescription(description, null);
        }
        catch (CoreException e) {
            JsonLog.logError(Messages.JsonValidationNature_3, e);
        }
    }

    public static boolean hasNature(IProject project) {
        try {
            return project.isOpen() && project.hasNature(NATURE_ID);
        }
        catch (CoreException e) {
            JsonLog.logError(Messages.JsonValidationNature_4, e);
            return false;
        }
    }

    public static void removeNature(IProject project) {
        IProjectDescription description;
        if (!project.isOpen()) {
            return;
        }
        try {
            description = project.getDescription();
        }
        catch (CoreException e) {
            JsonLog.logError(Messages.JsonValidationNature_5, e);
            return;
        }
        ArrayList<String> newIds = new ArrayList<String>();
        String[] natureIds = description.getNatureIds();
        newIds.addAll(Arrays.asList(natureIds));
        if (newIds.indexOf(NATURE_ID) == -1) {
            return;
        }
        newIds.remove(NATURE_ID);
        description.setNatureIds(newIds.toArray(new String[newIds.size()]));
        try {
            project.setDescription(description, null);
        }
        catch (CoreException e) {
            JsonLog.logError(Messages.JsonValidationNature_6, e);
        }
    }
}

