/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssLength;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssPercentage;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssBorderImageWidth
extends org.w3c.css.properties.css.CssBorderImageWidth {
    public static final CssIdent auto = CssIdent.getIdent("auto");

    public static final CssIdent getMatchingIdent(CssIdent ident) {
        return auto.equals(ident) ? auto : null;
    }

    public CssBorderImageWidth() {
        this.value = initial;
    }

    public CssBorderImageWidth(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        CssValueList valueList = new CssValueList();
        if (check2 && expression.getCount() > 4) {
            throw new InvalidParamException("unrecognize", ac);
        }
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            switch (val.getType()) {
                case 5: {
                    CssNumber num = val.getNumber();
                    num.checkPositiveness(ac, this);
                    valueList.add(val);
                    break;
                }
                case 6: {
                    CssLength length = val.getLength();
                    length.checkPositiveness(ac, this);
                    valueList.add(val);
                    break;
                }
                case 4: {
                    CssPercentage percent = val.getPercentage();
                    percent.checkPositiveness(ac, this);
                    valueList.add(val);
                    break;
                }
                case 0: {
                    if (inherit.equals(val)) {
                        if (expression.getCount() > 1) {
                            throw new InvalidParamException("unrecognize", ac);
                        }
                        valueList.add(inherit);
                        break;
                    }
                    if (auto.equals(val)) {
                        valueList.add(auto);
                        break;
                    }
                }
                default: {
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
            }
            expression.next();
            if (op == ' ') continue;
            throw new InvalidParamException("operator", Character.toString(op), ac);
        }
        this.value = valueList.size() == 1 ? valueList.get(0) : valueList;
    }

    public CssBorderImageWidth(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }
}

