/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.builder.ide;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.builder.BuildDependencyListener;
import org.tizen.common.builder.IBuildDependency;
import org.tizen.common.builder.IBuildListener;
import org.tizen.common.builder.IBuildProcess;
import org.tizen.common.builder.IBuilder;
import org.tizen.common.builder.core.AbstractBuilder;
import org.tizen.common.builder.dependency.DependencyInMemory;
import org.tizen.common.builder.exception.BuildException;
import org.tizen.common.builder.ide.IdeBuildProcess;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.ObjectUtil;
import org.tizen.common.util.PluginUtil;
import org.tizen.common.util.ResourceUtil;
import org.tizen.common.util.log.UserLogger;
import org.tizen.web.builder.AbstractLintBuilder;
import org.tizen.web.builder.CoffeeScriptBuilder;
import org.tizen.web.builder.CssLintBuilder;
import org.tizen.web.builder.JsHintBuilder;
import org.tizen.web.builder.LessBuilder;
import org.tizen.web.builder.PrivilegeCheckBuilder;
import org.tizen.web.builder.ide.ISourceCompressor;
import org.tizen.web.builder.ide.Messages;
import org.tizen.web.builder.ide.listener.ErrorMarkListener;
import org.tizen.web.builder.ide.manager.BuildManager;
import org.tizen.web.builder.ide.manager.ResourceManager;
import org.tizen.web.builder.ide.visitor.WebConfigValidationVisitor;
import org.tizen.web.common.WebConstant;
import org.tizen.web.common.util.PackageUtil;
import org.tizen.web.common.util.ProjectUtil;
import org.tizen.web.csslint.Activator;
import org.tizen.web.csslint.CssLintValidatorHelper;
import org.tizen.web.csslint.engine.CssLint;
import org.tizen.web.jshint.JsHintValidatorHelper;
import org.tizen.web.jshint.engine.JsHint;
import org.tizen.web.privilege.core.PrivilegeCheckHelper;

public class WebBuilder
extends IncrementalProjectBuilder {
    public static final String MARKER_ID = "org.tizen.web.builder.marker";
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected void clean(IProgressMonitor monitor) throws CoreException {
        Collection<org.tizen.common.file.IResource> originResources;
        IProject project = this.getProject();
        this.logger.debug("Clean the {} project...", (Object)project.getName());
        super.clean(monitor);
        IFolder folder = project.getFolder(".build");
        if (!folder.exists()) {
            folder.create(true, true, null);
        }
        folder.delete(true, null);
        project.deleteMarkers(MARKER_ID, false, 2);
        project.deleteMarkers("org.tizen.web.builder.marker.privilege", false, 2);
        project.deleteMarkers("org.tizen.web.builder.marker.js.lint", false, 2);
        project.deleteMarkers("org.tizen.web.builder.marker.css.lint", false, 2);
        IBuildDependency buildDependency = BuildManager.getBuildDependency(project.getName());
        if (buildDependency != null) {
            buildDependency.clear();
        }
        if ((originResources = ResourceManager.getOriginResources(project)) != null) {
            originResources.clear();
        }
        FileUtil.recursiveDelete((File)new File(PackageUtil.getPackagePath((IProject)project)));
    }

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        IConfigurationElement[] ces;
        UserLogger.start((String)"web.build");
        IProject project = this.getProject();
        IConfigurationElement[] iConfigurationElementArray = ces = PluginUtil.getExtensionConfigurationElements((String)"org.tizen.web.builder.src.compressor");
        int n = ces.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            if (ce.getAttribute("class") != null) {
                ISourceCompressor compressor = (ISourceCompressor)ce.createExecutableExtension("class");
                try {
                    compressor.compress(project);
                }
                catch (Exception e) {
                    this.logger.error("Source compression failed for the project: {}", (Object)project.getName());
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        this.logger.debug("Build start : {}, build type : {}", (Object)project.getName(), (Object)kind);
        project.refreshLocal(2, monitor);
        IResourceDelta delta = this.getDelta(project);
        TizenProjectDescription tproject = ProjectUtil.getTizenProjectDescription((IProject)project);
        project.deleteMarkers(MARKER_ID, false, 0);
        if (!InstallPathConfig.isSupportSameProfileToAppType((String)tproject.getProfileName(), (String)tproject.getVersion(), (String)"web")) {
            IMarker marker = project.createMarker(MARKER_ID);
            marker.setAttribute("severity", 2);
            marker.setAttribute("priority", 2);
            String errMsg = MessageFormat.format(org.tizen.common.Messages.CANNOT_SUPPORT_PLATFORM, tproject.getPlatformName());
            marker.setAttribute("message", (Object)errMsg);
            return null;
        }
        ResourceManager resourceManager = new ResourceManager(project);
        resourceManager.setExcludes(this.getExcludesPattern().toArray(new String[0]));
        this.updateResourceState(resourceManager, project, kind);
        if (kind != 15 && delta == null) {
            kind = 6;
        }
        monitor = (IProgressMonitor)ObjectUtil.nvl((Object[])new IProgressMonitor[]{monitor, new NullProgressMonitor()});
        monitor.beginTask("Building " + project.getName() + "...", -1);
        this.handleMonitorCancel(monitor);
        Collection<org.tizen.common.file.IResource> deltaResources = resourceManager.getDeltaResources();
        this.validateConfig(kind, project, deltaResources);
        this.handleMonitorCancel(monitor);
        IdeBuildProcess buildProcess = new IdeBuildProcess(monitor);
        buildProcess.addListener((IBuildListener)new BuildDependencyListener(BuildManager.getBuildDependency(project.getName(), (IBuildDependency)new DependencyInMemory())));
        this.generateBuilder((IBuildProcess)buildProcess);
        this.handleMonitorCancel(monitor);
        try {
            buildProcess.build(deltaResources.toArray(new org.tizen.common.file.IResource[0]));
        }
        catch (BuildException e) {
            this.forgetLastBuiltState();
            throw new CoreException((IStatus)new Status(4, "org.tizen.web.builder", e.getMessage(), (Throwable)e));
        }
        this.logger.debug("build end : {}", (Object)project.getName());
        UserLogger.end((String)"web.build");
        return null;
    }

    private void validateConfig(int kind, IProject project, Collection<org.tizen.common.file.IResource> deltaResources) throws CoreException {
        IResource configRes = project.findMember("config.xml");
        boolean needToCheck = true;
        switch (kind) {
            case 10: {
                org.tizen.common.file.IResource configResource = ResourceUtil.getResource((String)"config.xml", (org.tizen.common.file.IResource[])deltaResources.toArray(new org.tizen.common.file.IResource[0]));
                if (configResource != null) break;
                needToCheck = false;
                break;
            }
        }
        if (needToCheck) {
            WebConfigValidationVisitor validationVisitor = new WebConfigValidationVisitor(project);
            if (configRes == null) {
                IMarker marker = project.createMarker(MARKER_ID);
                marker.setAttribute("severity", 2);
                marker.setAttribute("priority", 2);
                marker.setAttribute("message", (Object)Messages.CONFIG_RESOURCE_DOES_NOT_EXIST);
            } else {
                project.deleteMarkers(MARKER_ID, false, 0);
                configRes.accept((IResourceVisitor)validationVisitor);
            }
        }
    }

    private Collection<String> getExcludesPattern() {
        HashSet<String> excludes = new HashSet<String>();
        excludes.add(PackageUtil.getPackageName((IProject)this.getProject()));
        excludes.addAll(Arrays.asList(WebConstant.DEFAULT_EXCLUDING_RESOURCES));
        return excludes;
    }

    private void updateResourceState(ResourceManager resourceManager, IProject project, int kind) throws CoreException {
        switch (kind) {
            case 9: 
            case 10: {
                this.logger.debug("Update resource state.");
                this.getDelta(project).accept((IResourceDeltaVisitor)resourceManager);
                break;
            }
            default: {
                project.accept((IResourceVisitor)resourceManager);
            }
        }
    }

    private void generateBuilder(IBuildProcess buildProcess) {
        buildProcess.addBuilders(this.createPrivilegeCheckBuilder());
        buildProcess.addBuilders(this.createLintBuilders());
        buildProcess.addBuilders(this.createTranslationBuilders());
    }

    private IBuilder[] createTranslationBuilders() {
        ArrayList<AbstractBuilder> builders = new ArrayList<AbstractBuilder>();
        String outputPath = FileUtil.appendPath((String)this.getProject().getLocation().toOSString(), (String)".build");
        CoffeeScriptBuilder coffeeCompiler = new CoffeeScriptBuilder(FileUtil.appendPath((String)outputPath, (String)"compiled-coffee"));
        coffeeCompiler.addListener(new ErrorMarkListener(this.getProject(), "org.tizen.web.builder.marker.coffee.compile"));
        LessBuilder lessCompiler = new LessBuilder(FileUtil.appendPath((String)outputPath, (String)"compiled-less"));
        lessCompiler.addListener(new ErrorMarkListener(this.getProject(), "org.tizen.web.builder.marker.less.compile"));
        builders.add(coffeeCompiler);
        builders.add(lessCompiler);
        return builders.toArray(new IBuilder[0]);
    }

    private IBuilder[] createLintBuilders() {
        IPreferenceStore cssPreferenceStore;
        ArrayList<AbstractLintBuilder> builders = new ArrayList<AbstractLintBuilder>();
        IProject project = this.getProject();
        IPreferenceStore jsPreferenceStore = org.tizen.web.jshint.Activator.getJsPreferenceStore();
        if (jsPreferenceStore.getBoolean("org.tizen.web.jshint.preference.JsValidationPreferencePage.build")) {
            JsHintBuilder jsHintBuilder = new JsHintBuilder(new ErrorMarkListener(project, "org.tizen.web.builder.marker.js.lint"));
            jsHintBuilder.setExcludes(JsHintValidatorHelper.getExcludeJsResources());
            jsHintBuilder.setExcludeFolders(JsHintValidatorHelper.getExcludeFolders());
            jsHintBuilder.setCheckingErrorLevel(JsHintValidatorHelper.getErrorLevel());
            JsHintValidatorHelper.setPreferenceOptions((JsHint)jsHintBuilder.getJsHintValidator().getJsHint());
            builders.add(jsHintBuilder);
        }
        if ((cssPreferenceStore = Activator.getCssPreferenceStore()).getBoolean("org.tizen.web.csslint.preference.CssLintPreferencePage.build")) {
            CssLintBuilder cssLintBuilder = new CssLintBuilder(new ErrorMarkListener(project, "org.tizen.web.builder.marker.css.lint"));
            cssLintBuilder.setExcludes(CssLintValidatorHelper.getExcludeCSSResources());
            cssLintBuilder.setExcludeFolders(CssLintValidatorHelper.getExcludeFolders());
            cssLintBuilder.setCheckingErrorLevel(CssLintValidatorHelper.getErrorLevel());
            CssLintValidatorHelper.setPreferenceOptions((CssLint)cssLintBuilder.getCSSLintValidator().getCssLint());
            builders.add(cssLintBuilder);
        }
        return builders.toArray(new IBuilder[0]);
    }

    private IBuilder[] createPrivilegeCheckBuilder() {
        ArrayList<PrivilegeCheckBuilder> builders = new ArrayList<PrivilegeCheckBuilder>();
        IPreferenceStore privilegePreferenceStore = org.tizen.web.privilege.Activator.getPrivilegPreferenceStore();
        if (privilegePreferenceStore.getBoolean("org.tizen.web.privilege.preference.PrivilegePreferencePage.build")) {
            IProject project = this.getProject();
            PrivilegeCheckBuilder privilegeCheckBuilder = new PrivilegeCheckBuilder(project, (IBuildListener)new ErrorMarkListener(project, "org.tizen.web.builder.marker.privilege"));
            privilegeCheckBuilder.setExcludes(PrivilegeCheckHelper.getExcludeFiles());
            privilegeCheckBuilder.setExcludeFolders(PrivilegeCheckHelper.getExcludeFolders());
            privilegeCheckBuilder.setCheckingErrorLevel(PrivilegeCheckHelper.getErrorLevel());
            builders.add(privilegeCheckBuilder);
        }
        return builders.toArray(new IBuilder[0]);
    }

    private void handleMonitorCancel(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }
}

