/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.step;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.core.resources.IProject;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.Version;
import org.tizen.common.launch.context.ILaunchContext;
import org.tizen.common.sdb.command.SdbCommandHelper;
import org.tizen.common.sdb.command.receiver.CommandOutputReceiver;
import org.tizen.common.ui.view.console.ITizenConsoleManager;
import org.tizen.common.util.PlatformInformationUtil;
import org.tizen.common.util.log.UserLogger;
import org.tizen.sdblib.IDevice;
import org.tizen.web.common.util.ProjectUtil;
import org.tizen.web.zimlaunch.command.WebLaunchCommand;
import org.tizen.web.zimlaunch.core.CompositeStep;
import org.tizen.web.zimlaunch.core.IStep;
import org.tizen.web.zimlaunch.exception.TizenWebIDEException;
import org.tizen.web.zimlaunch.exception.TizenWebIDEExceptionCode;
import org.tizen.web.zimlaunch.notification.TizenWebConsole;
import org.tizen.web.zimlaunch.notification.TizenWebNotifier;
import org.tizen.web.zimlaunch.resource.TizenWebAppInfo;
import org.tizen.web.zimlaunch.resource.ZimLaunchResource;
import org.tizen.web.zimlaunch.step.KillStep;
import org.tizen.web.zimlaunch.step.Messages;
import org.tizen.web.zimlaunch.util.CommandLauncher;
import org.tizen.web.zimlaunch.util.LaunchUtil;
import org.tizen.web.zimlaunch.util.jsconsole.JsLogConsoleFactory;
import org.tizen.web.zimlaunch.util.jsconsole.JsLogReceiver;

public abstract class LaunchStep
extends CompositeStep {
    protected static final Logger logger = LoggerFactory.getLogger(LaunchStep.class);
    public static final String name = Messages.RUN_PACKAGE;
    protected CommandLauncher launcher;
    protected TizenWebNotifier notifier;
    protected ZimLaunchResource resource;
    protected IDevice device;
    protected boolean isInstalled;
    private SdbCommandHelper command;
    protected int percent;

    public LaunchStep(IStep ... steps) {
        super(steps);
    }

    @Override
    public void executeStep(ILaunchContext ctx) throws Exception {
        this.executeStep(ctx, false);
    }

    public void executeStep(ILaunchContext ctx, boolean isWebWidget) throws Exception {
        UserLogger.start((String)"web.launch", (String)".run");
        this.preExecuteStep(ctx);
        String failMessage = Messages.getFailMessage((String)Messages.RUN_PACKAGE);
        String errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)name);
        if (!this.isInstalled) {
            TizenWebIDEExceptionCode code = TizenWebIDEExceptionCode.WEB_IDE_WIDGET_NOT_INSTALLED;
            logger.error(this.makeErrorDescription(code));
            TizenWebIDEException.abort(failMessage, new TizenWebIDEException(String.format("%s\n%s %s", errMsg, code.getDescription(), org.tizen.web.zimlaunch.exception.Messages.TRY_AGAIN_MSG)), new TizenWebNotifier[0]);
            return;
        }
        this.closeJsLogConsole(this.device);
        CommandOutputReceiver receiver = new CommandOutputReceiver((ITizenConsoleManager)TizenWebConsole.getInstance());
        this.command = new SdbCommandHelper(this.device, null, receiver);
        Calendar calendar = this.getCurrentDeviceCalendar(this.device);
        this.executeLaunchCommand();
        this.postRun();
        this.openJsLogConsole(calendar);
        try {
            try {
                super.executeStep(ctx);
            }
            catch (Exception e) {
                this.handleExecuteException(e, ctx);
                UserLogger.end((String)"web.launch", (String)".run");
            }
        }
        finally {
            UserLogger.end((String)"web.launch", (String)".run");
        }
    }

    protected void executeLaunchCommand() throws Exception {
        String appId = this.resource.getAppinfo().getAppID();
        boolean useWidgetViewerSdk = false;
        if (LaunchUtil.isWatch(this.resource.getAppinfo().getProject())) {
            useWidgetViewerSdk = true;
        } else if (ProjectUtil.isWebWidgetProject((IProject)this.resource.getAppinfo().getProject())) {
            useWidgetViewerSdk = true;
            appId = this.resource.getAppinfo().getAppWidgetID();
        }
        WebLaunchCommand command = new WebLaunchCommand(this.device, appId, "", useWidgetViewerSdk, (ITizenConsoleManager)TizenWebConsole.getInstance());
        command.execute();
        String result = command.getCommandOutput();
        if (!result.contains("... successfully launched")) {
            TizenWebIDEExceptionCode code = TizenWebIDEExceptionCode.WEB_IDE_STEPRUN_FAIL;
            logger.error(this.makeErrorDescription(code));
            TizenWebIDEException.abort(Messages.getFailMessage((String)Messages.RUN_PACKAGE), new TizenWebIDEException(String.format("%s\n%s %s", NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)name), code.getDescription(), org.tizen.web.zimlaunch.exception.Messages.TRY_AGAIN_MSG)), new TizenWebNotifier[0]);
        }
    }

    protected void handleExecuteException(Exception e, ILaunchContext ctx) throws Exception {
        if (e != null) {
            new KillStep().executeStep(ctx);
            throw e;
        }
    }

    protected Calendar getCurrentDeviceCalendar(IDevice device) throws Exception {
        if (device == null) {
            return null;
        }
        this.command.runCommand("date +\"%Y-%m-%d %H:%M:%S\"");
        SimpleDateFormat ft = new SimpleDateFormat("y-MM-dd hh:mm:ss");
        String result = this.command.getCommandOutput();
        Date date = ft.parse(result);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return calendar;
    }

    private void closeJsLogConsole(IDevice device) {
        if (device == null) {
            return;
        }
        JsLogConsoleFactory.closeJsLogConsole(device);
    }

    protected void openJsLogConsole(Calendar calendar) throws IOException {
        TizenWebAppInfo appInfo = this.resource.getAppinfo();
        IProject project = appInfo.getProject();
        String packageID = appInfo.getAppPackageID();
        String profile = appInfo.getProfile();
        Version version = new Version(appInfo.getVersion());
        JsLogReceiver receiver = new JsLogReceiver();
        receiver.setCalendar(calendar);
        receiver.setTargetVersion(new Version(PlatformInformationUtil.getPlatformVersion((IDevice)this.device)));
        JsLogConsoleFactory.openJsLogConsole(project, this.device, packageID, receiver, profile, version);
    }

    protected void postRun() {
        String[] resultLineStrings = this.command.getResultLineStrings();
        if (resultLineStrings != null) {
            String[] stringArray = resultLineStrings;
            int n = resultLineStrings.length;
            int n2 = 0;
            while (n2 < n) {
                String result = stringArray[n2];
                logger.debug("  " + result);
                ++n2;
            }
        }
    }

    protected void preExecuteStep(ILaunchContext ctx) throws Exception {
        String failMessage = Messages.getFailMessage((String)Messages.TRANSFER_PACKAGE);
        String msg = String.valueOf(NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)name)) + "\n" + org.tizen.web.zimlaunch.exception.Messages.TRY_AGAIN_MSG;
        this.resource = (ZimLaunchResource)ctx.getValue((Object)"resource");
        if (this.resource == null) {
            logger.error(this.makeErrorDescription(TizenWebIDEExceptionCode.WEB_IDE_STEPCONTEXT_CAN_NOT_FIND_LAUNCH_RESOURCE));
            TizenWebIDEException.abort(failMessage, new TizenWebIDEException(msg), new TizenWebNotifier[0]);
        }
        this.device = this.resource.getDeviceinfo().getDevice();
        JsLogConsoleFactory.clear(this.device);
        this.launcher = (CommandLauncher)ctx.getValue((Object)"command launcher");
        if (this.launcher == null) {
            logger.error(this.makeErrorDescription(TizenWebIDEExceptionCode.WEB_IDE_STEPCONTEXT_CAN_NOT_FIND_COMMNAD_LAUNCHER));
            TizenWebIDEException.abort(failMessage, new TizenWebIDEException(msg), new TizenWebNotifier[0]);
        }
        this.notifier = (TizenWebNotifier)ctx.getValue((Object)"notifier");
        this.isInstalled = (Boolean)ctx.getValue((Object)"widget installation");
        this.work = 100;
        this.rwork = 100;
        this.percent = 10;
        this.pwork = this.notifier.getRemainWork() < 20 ? this.notifier.getPercentRemainWork(this.percent) : this.notifier.getRemainWork() - 1;
    }

    @Override
    public String getStepName() {
        return name;
    }
}

