/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.step;

import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.file.IResource;
import org.tizen.common.launch.context.ILaunchContext;
import org.tizen.common.util.log.UserLogger;
import org.tizen.web.zimlaunch.command.WebInstallCommand;
import org.tizen.web.zimlaunch.core.CompositeStep;
import org.tizen.web.zimlaunch.core.IStep;
import org.tizen.web.zimlaunch.exception.TizenWebIDEException;
import org.tizen.web.zimlaunch.exception.TizenWebIDEExceptionCode;
import org.tizen.web.zimlaunch.notification.TizenWebConsole;
import org.tizen.web.zimlaunch.notification.TizenWebNotifier;
import org.tizen.web.zimlaunch.resource.ZimLaunchResource;
import org.tizen.web.zimlaunch.step.Messages;
import org.tizen.web.zimlaunch.util.CommandLauncher;

public class UpdateStep
extends CompositeStep {
    protected static final Logger logger = LoggerFactory.getLogger(UpdateStep.class);
    public static final String name = Messages.STEP_UPDATE;
    protected CommandLauncher launcher;
    protected TizenWebNotifier notifier;
    protected ZimLaunchResource resource;
    private String localPkgFilePath;
    protected int percent;

    public UpdateStep() {
        super(new IStep[0]);
    }

    @Override
    public void executeStep(ILaunchContext ctx) throws Exception {
        UserLogger.start((String)"web.launch", (String)".update");
        this.preExecuteStep(ctx);
        String errMsg = "";
        int code = 0;
        this.notifier.notifyContents("Updating... ", this.getWorkCount(10));
        String packageFile = this.resource.getAppinfo().getAppFile().getName();
        IResource packageResource = (IResource)ctx.getValue((Object)"package");
        this.localPkgFilePath = packageResource.getPath();
        WebInstallCommand command = new WebInstallCommand(this.launcher.getDevice(), packageFile, this.localPkgFilePath, TizenWebConsole.getInstance());
        command.execute();
        if (code != 0) {
            code = TizenWebIDEExceptionCode.WEB_IDE_STEPUPDATE_FAIL.getCode();
            errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)name);
            TizenWebIDEException.abort(Messages.getFailMessage((String)Messages.STEP_UPDATE), new TizenWebIDEException(errMsg, code), this.notifier);
        }
        this.notifier.notifyContents("Updating command success", this.getWorkCount(50));
        UserLogger.end((String)"web.launch", (String)".update");
    }

    protected void preExecuteStep(ILaunchContext ctx) throws Exception {
        String errMsg = "";
        int code = 0;
        this.launcher = (CommandLauncher)ctx.getValue((Object)"command launcher");
        String eMsg = Messages.getFailMessage((String)Messages.TRANSFER_PACKAGE);
        if (this.launcher == null) {
            code = TizenWebIDEExceptionCode.WEB_IDE_STEPCONTEXT_CAN_NOT_FIND_COMMNAD_LAUNCHER.getCode();
            errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)Messages.STEP_CONTEXT_HANDLE);
            TizenWebIDEException.abort(eMsg, new TizenWebIDEException(errMsg, code), new TizenWebNotifier[0]);
        }
        this.resource = (ZimLaunchResource)ctx.getValue((Object)"resource");
        if (this.resource == null) {
            code = TizenWebIDEExceptionCode.WEB_IDE_STEPCONTEXT_CAN_NOT_FIND_LAUNCH_RESOURCE.getCode();
            errMsg = NLS.bind((String)Messages.UNEXPECTED_OPERATION, (Object)Messages.STEP_CONTEXT_HANDLE);
            TizenWebIDEException.abort(eMsg, new TizenWebIDEException(errMsg, code), new TizenWebNotifier[0]);
        }
        this.notifier = (TizenWebNotifier)ctx.getValue((Object)"notifier");
        this.work = 100;
        this.rwork = 100;
        this.percent = 10;
        this.pwork = this.notifier.getRemainWork() < 20 ? this.notifier.getPercentRemainWork(this.percent) : 10;
    }

    @Override
    public String getStepName() {
        return name;
    }
}

