/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.common;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.web.common.CommonMessages;

public class IDEPathUtil {
    static final Logger logger = LoggerFactory.getLogger(IDEPathUtil.class);
    private static final String PROJECT_WIZARD_SYMBOLIC_NAME = "org.tizen.web.project.wizard";

    public static IPath getUserTemplatePath() {
        String sdkPath = InstallPathConfig.getUserDataPath();
        IPath templatePath = new Path(sdkPath).append("ide").append("user-templates").append("web");
        return templatePath;
    }

    public static String getUserTemplatePathByString() {
        return IDEPathUtil.getUserTemplatePath().toOSString();
    }

    public static String getBuiltInTemplateLibrariesPath() {
        return IDEPathUtil.getBuiltInPath(PROJECT_WIZARD_SYMBOLIC_NAME, "templateLibraries");
    }

    public static String getBuiltInPath(String symbolicName, String entryPath) {
        URI sourceURI = null;
        try {
            URL sourceURL = FileLocator.toFileURL((URL)Platform.getBundle((String)symbolicName).getEntry(entryPath));
            sourceURI = URIUtil.toURI((URL)sourceURL);
        }
        catch (IOException e) {
            logger.error(CommonMessages.IDEPathUtil_template_error, (Throwable)e);
        }
        catch (URISyntaxException e) {
            logger.error(CommonMessages.IDEPathUtil_template_error, (Throwable)e);
        }
        return sourceURI == null ? null : sourceURI.getPath();
    }

    public static String getWebUIFWTemplateLibrariesPath(ProfileInfo profileInfo) {
        String platformPath = profileInfo.getPlatformPath(profileInfo.getLatestPlatformVersion());
        IPath uiFWPath = new Path(platformPath).append("web-ui-fw");
        return uiFWPath.toOSString();
    }

    public static String getWebWidgetCodeAssistDir(ProfileInfo profileInfo, String version) {
        String platformPath = profileInfo.getPlatformPath(version);
        return String.valueOf(platformPath) + File.separator + "codeassist/webwidget";
    }
}

