/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.wizard.ui;

import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.tproject.Platform;
import org.tizen.common.core.application.tproject.Platforms;
import org.tizen.common.core.application.tproject.Tproject;
import org.tizen.common.core.application.tproject.TprojectHandler;
import org.tizen.common.util.BrowserWrapper;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.FreeMarkerUtil;
import org.tizen.common.util.ImageUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.web.common.IDEPathUtil;
import org.tizen.web.project.wizard.Activator;
import org.tizen.web.project.wizard.WizardMessages;
import org.tizen.web.project.wizard.ui.UserTemplateExportWizard;

public class UserTemplateExportWizardDescriptionPage
extends WizardPage {
    protected static final Logger logger = LoggerFactory.getLogger(UserTemplateExportWizardDescriptionPage.class);
    public static final String DESCRIPTION_TEMPLATE_DIR = "descriptionTemplate";
    public static final String DESCRIPTION_XML = "description.xml";
    public static final String DESCRIPTION_XSL = "description.xsl";
    private final int browserHeight = 350;
    private final int browserWidth = 418;
    private final String defaultNameText = WizardMessages.UserTemplateExportWizardDescriptionPage_DefaultName;
    private final String defaultDescriptionText = WizardMessages.UserTemplateExportWizardDescriptionPage_DefaultDescription;
    private final String defaultDescriptionVersion = "1.0";
    private final String defaultTemplateVersion = "1.0";
    private final String defaultTemplateCategory = "TizenWeb";
    private final String defaultTemplateHasOption = "false";
    private final String defaultTemplateProjectType = "TIZEN";
    private final String TIZEN_PROJECT_DESCRIPTION_FILE = ".tproject";
    private Text nameText;
    private StyledText descriptionText;
    private Text previewImageText;
    private BrowserWrapper browserWrapper;
    private UserTemplateExportWizard userTemplateExportWizard;
    private FocusListener focusRefreshListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            UserTemplateExportWizardDescriptionPage.this.refreshPreview();
        }
    };
    private Map<String, Object> root;
    private Configuration cfg;
    private File temporaryFile;

    public UserTemplateExportWizardDescriptionPage(String pageName) {
        super(pageName);
        this.initilize();
    }

    public UserTemplateExportWizardDescriptionPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.initilize();
    }

    public UserTemplateExportWizardDescriptionPage(String pageName, UserTemplateExportWizard userTemplateExportWizard) {
        super(pageName);
        this.userTemplateExportWizard = userTemplateExportWizard;
        this.initilize();
    }

    protected void initilize() {
        this.root = new HashMap<String, Object>();
        try {
            this.cfg = FreeMarkerUtil.getConfiguration((AbstractUIPlugin)Activator.getDefault(), (String)DESCRIPTION_TEMPLATE_DIR);
            String tempFileName = FileUtil.getFileNameWithoutExtension((String)DESCRIPTION_XML);
            String tempFileExtension = FileUtil.getFileExtension((String)DESCRIPTION_XML);
            this.temporaryFile = File.createTempFile(tempFileName, tempFileExtension);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        Composite subComposite = new Composite(composite, 0);
        subComposite.setLayout((Layout)new GridLayout(4, false));
        subComposite.setLayoutData((Object)new GridData(768));
        Label nameLabel = new Label(subComposite, 0);
        nameLabel.setText(WizardMessages.UserTemplateExportWizardDescriptionPage_NameLabel);
        GridData nameLabelGridData = new GridData(768);
        nameLabelGridData.horizontalSpan = 2;
        nameLabel.setLayoutData((Object)nameLabelGridData);
        GridData browserGridData = new GridData(1808);
        browserGridData.horizontalSpan = 2;
        browserGridData.verticalSpan = 4;
        browserGridData.minimumHeight = 350;
        browserGridData.minimumWidth = 418;
        this.browserWrapper = new BrowserWrapper(subComposite, 2048, browserGridData);
        this.nameText = new Text(subComposite, 2048);
        GridData nameTextGridData = new GridData(768);
        nameTextGridData.horizontalSpan = 2;
        this.nameText.setLayoutData((Object)nameTextGridData);
        this.nameText.setText(this.defaultNameText);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UserTemplateExportWizardDescriptionPage.this.validatePage();
            }
        });
        this.nameText.addFocusListener(this.focusRefreshListener);
        Label descriptionLabel = new Label(subComposite, 0);
        descriptionLabel.setText(WizardMessages.UserTemplateExportWizardDescriptionPage_DescriptionLabel);
        GridData descriptionLabelGridData = new GridData(768);
        descriptionLabelGridData.horizontalSpan = 2;
        descriptionLabel.setLayoutData((Object)descriptionLabelGridData);
        this.descriptionText = new StyledText(subComposite, 2370);
        GridData descriptionTextGridData = new GridData(1808);
        descriptionTextGridData.horizontalSpan = 2;
        this.descriptionText.setLayoutData((Object)descriptionTextGridData);
        this.descriptionText.setText(this.defaultDescriptionText);
        this.descriptionText.addFocusListener(this.focusRefreshListener);
        Composite subComposite2 = new Composite(composite, 0);
        subComposite2.setLayout((Layout)new GridLayout(4, false));
        subComposite2.setLayoutData((Object)new GridData(768));
        Label previewImageLabel = new Label(subComposite2, 0);
        previewImageLabel.setText(WizardMessages.UserTemplateExportWizardDescriptionPage_PreviewLabel);
        previewImageLabel.setLayoutData((Object)new GridData());
        this.previewImageText = new Text(subComposite2, 2048);
        GridData previewImageGridData = new GridData(768);
        previewImageGridData.horizontalSpan = 2;
        this.previewImageText.setLayoutData((Object)previewImageGridData);
        this.previewImageText.addFocusListener(this.focusRefreshListener);
        Button browseButton = new Button(subComposite2, 8);
        browseButton.setText(WizardMessages.UserTemplateExportWizardDescriptionPage_BrowseButton);
        browseButton.setLayoutData((Object)new GridData());
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserTemplateExportWizardDescriptionPage.this.handleBrowseButtonPressed();
            }
        });
        this.setControl((Control)composite);
        this.validatePage();
        this.refreshPreview();
    }

    public void dispose() {
        if (this.temporaryFile != null) {
            this.temporaryFile.deleteOnExit();
        }
        super.dispose();
    }

    protected boolean validatePage() {
        File previewImageFile;
        String name = this.getDescriptionNameText();
        if (name.isEmpty()) {
            this.setErrorMessage(WizardMessages.UserTemplateExportWizardDescriptionPage_NonameErrorMsg);
            this.setPageComplete(false);
            return false;
        }
        String previewImage = this.getPreviewImageText();
        if (!(previewImage.isEmpty() || (previewImageFile = new File(previewImage)).exists() && previewImageFile.canRead())) {
            this.setErrorMessage(WizardMessages.UserTemplateExportWizardDescriptionPage_InvalidPreviewPathErrorMsg);
            this.setPageComplete(false);
            return false;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
        return true;
    }

    protected void handleBrowseButtonPressed() {
        String selectedFile;
        FileDialog fileDialog = new FileDialog(this.previewImageText.getShell(), 0x10000000);
        fileDialog.setText(WizardMessages.UserTemplateExportWizardDescriptionPage_PreviewFileDialog);
        fileDialog.setFilterExtensions(ImageUtil.supportedImageExtension);
        String previewText = this.getPreviewImageText();
        if (previewText != null) {
            File file = new File(previewText);
            fileDialog.setFilterPath(file.getParent());
        }
        if ((selectedFile = fileDialog.open()) != null) {
            try {
                Image image = new Image((Device)Display.getDefault(), selectedFile);
                if (image != null) {
                    this.previewImageText.setText(selectedFile);
                    this.refreshPreview();
                }
            }
            catch (SWTException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void refreshPreview() {
        try {
            if (this.temporaryFile != null) {
                this.generateDescriptionXML(this.temporaryFile, true);
                this.browserWrapper.setUrl(this.temporaryFile);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void setXMLInformation(boolean absolutePath) {
        String xslAbsolutePath = String.valueOf(IDEPathUtil.getUserTemplatePath().toOSString()) + File.separator + DESCRIPTION_XSL;
        this.root.put("DescriptionXSL", absolutePath ? xslAbsolutePath : DESCRIPTION_XSL);
        this.root.put("DescriptionVersion", "1.0");
        this.root.put("Name", this.getDescriptionNameText());
        this.root.put("Version", "1.0");
        IProject selectProject = this.userTemplateExportWizard.getSelectedProject();
        String profileName = null;
        String requiredVersion = null;
        String platformInfo = this.getPlatformByTprojectInDirectory(selectProject.getLocation().toOSString());
        if (platformInfo == null || !platformInfo.contains("-")) {
            return;
        }
        String[] platformArr = platformInfo.split("-");
        if (platformArr == null || platformArr.length < 1) {
            return;
        }
        profileName = platformArr[0];
        requiredVersion = platformArr[1];
        this.root.put("ProfileName", profileName);
        this.root.put("RequiredVersion", requiredVersion);
        this.root.put("ProjectType", "TIZEN");
        this.root.put("HasOption", "false");
        this.root.put("Category", "TizenWeb");
        String previewImageText = this.getPreviewImageText();
        Path previewPath = new Path(previewImageText);
        String previewFileName = previewPath.lastSegment() != null ? previewPath.lastSegment() : "";
        this.root.put("PreviewImage", absolutePath ? previewImageText : previewFileName);
        this.root.put("DescriptionText", this.getDescriptionText());
    }

    public void generateDescriptionXML(File destinationFile, boolean absolutePath) throws IOException, TemplateException {
        this.setXMLInformation(absolutePath);
        FreeMarkerUtil.generateDocument(this.root, (Configuration)this.cfg, (String)DESCRIPTION_XML, (File)destinationFile);
    }

    public String getDescriptionText() {
        return this.descriptionText.getText();
    }

    public String getDescriptionNameText() {
        return this.nameText.getText().trim();
    }

    public String getPreviewImageText() {
        return this.previewImageText.getText().trim();
    }

    protected String getPlatformByTprojectInDirectory(String path) {
        if (StringUtil.isEmpty((CharSequence)path)) {
            return null;
        }
        File tprojectFile = new File(path, ".tproject");
        if (!tprojectFile.exists()) {
            return null;
        }
        logger.debug("Found a '.tproject' file");
        Tproject tproject = TprojectHandler.unmarshalTproject((File)tprojectFile);
        if (tproject == null) {
            logger.debug("Failed to get tproject model");
            return null;
        }
        Platforms platforms = tproject.getPlatforms();
        if (platforms == null) {
            logger.debug("tproject model don't have platforms");
            return null;
        }
        List platform = platforms.getPlatform();
        if (platform == null || platform.isEmpty()) {
            logger.debug("tproject model have an enmpty platform in platforms");
            return null;
        }
        return ((Platform)platform.get(0)).getName();
    }
}

