/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.util;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.core.application.Version;
import org.tizen.common.rds.ui.preference.RdsPreferencePage;
import org.tizen.common.util.Assert;
import org.tizen.common.util.PlatformInformationUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.exception.SdbCommandRejectedException;
import org.tizen.sdblib.exception.TimeoutException;
import org.tizen.web.browser.Activator;
import org.tizen.web.common.WebCommonActivator;
import org.tizen.web.common.util.ProjectUtil;
import org.tizen.web.config.schema.model.Category;
import org.tizen.web.editor.configuration.ConfigurationException;
import org.tizen.web.editor.configuration.ConfiguratorFactory;
import org.tizen.web.editor.configuration.IMobileConfigurator;
import org.tizen.web.editor.configuration.ITizenConfigurator;
import org.tizen.web.zimlaunch.constants.LaunchType;
import org.tizen.web.zimlaunch.constants.TizenWebLaunchConstants;

public class LaunchUtil
extends org.tizen.common.util.LaunchUtil {
    protected static final Logger logger = LoggerFactory.getLogger(LaunchUtil.class);
    private static final String[] CANNOT_RUN_APP_CATEGORIES = new String[]{"http://tizen.org/category/downloadable_font"};
    private static final String[] CANNOT_RUN_WEARABLE_APP_CATEGORIES = new String[]{"com.samsung.wmanager.WATCH_CLOCK", "http://tizen.org/category/wearable_clock"};

    public static boolean canRun(IProject project) throws ConfigurationException {
        if (project == null) {
            return false;
        }
        ITizenConfigurator wgtConfig = ConfiguratorFactory.unmarshalWidgetConfiguration((IProject)project);
        boolean isWearableProject = LaunchUtil.isWearable(project);
        if (wgtConfig instanceof IMobileConfigurator) {
            IMobileConfigurator mConfig = (IMobileConfigurator)wgtConfig;
            if (mConfig != null && mConfig.isIME()) {
                return false;
            }
            for (Category category : mConfig.getCategories()) {
                String compareName = category.getName();
                String[] stringArray = CANNOT_RUN_APP_CATEGORIES;
                int n = CANNOT_RUN_APP_CATEGORIES.length;
                int n2 = 0;
                while (n2 < n) {
                    String categoryName = stringArray[n2];
                    if (categoryName.equals(compareName)) {
                        return false;
                    }
                    ++n2;
                }
                if (!isWearableProject) continue;
                IDevice device = ConnectionPlugin.getDefault().getCurrentDevice();
                try {
                    Version version = new Version(PlatformInformationUtil.getPlatformVersion((IDevice)device));
                    if (version.isSameOrBiggerThanVersion3()) {
                        continue;
                    }
                }
                catch (Exception e) {
                    logger.warn("Failed to get version", (Throwable)e);
                }
                String[] stringArray2 = CANNOT_RUN_WEARABLE_APP_CATEGORIES;
                int n3 = CANNOT_RUN_WEARABLE_APP_CATEGORIES.length;
                n = 0;
                while (n < n3) {
                    String categoryName = stringArray2[n];
                    if (categoryName.equals(compareName)) {
                        return false;
                    }
                    ++n;
                }
            }
        }
        return true;
    }

    public static boolean isWatch(IProject project) throws ConfigurationException {
        ITizenConfigurator wgtConfig = ConfiguratorFactory.unmarshalWidgetConfiguration((IProject)project);
        if (wgtConfig instanceof IMobileConfigurator) {
            IMobileConfigurator mConfig = (IMobileConfigurator)wgtConfig;
            for (Category category : mConfig.getCategories()) {
                String compareName = category.getName();
                String[] stringArray = CANNOT_RUN_WEARABLE_APP_CATEGORIES;
                int n = CANNOT_RUN_WEARABLE_APP_CATEGORIES.length;
                int n2 = 0;
                while (n2 < n) {
                    String categoryName = stringArray[n2];
                    if (categoryName.equals(compareName)) {
                        return true;
                    }
                    ++n2;
                }
            }
        }
        return false;
    }

    public static boolean isWebServiceApplication(IProject project) throws ConfigurationException {
        IMobileConfigurator mConfig;
        ITizenConfigurator wgtConfig = ConfiguratorFactory.unmarshalWidgetConfiguration((IProject)project);
        return wgtConfig instanceof IMobileConfigurator && (mConfig = (IMobileConfigurator)wgtConfig).getService() != null;
    }

    public static boolean isRdsMode(IProject project) {
        if (ProjectUtil.isWebWidgetProject((IProject)project)) {
            return false;
        }
        return RdsPreferencePage.isRdsMode((IProject)project);
    }

    public static boolean isLiveEditingMode(ILaunchConfiguration config) throws CoreException {
        Assert.notNull((Object)config);
        return config.getAttribute(TizenWebLaunchConstants.ATTR_LIVE_EDITING, Activator.isEnabledLiveEditing());
    }

    public static boolean needFullInstall(IProject project) {
        String needFullInstall;
        try {
            needFullInstall = project.getPersistentProperty(WebCommonActivator.needFullInstallQName);
            if (needFullInstall == null) {
                return false;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
        return Boolean.parseBoolean(needFullInstall);
    }

    public static void setFullInstall(IProject project, boolean needFullInstall) throws CoreException {
        project.setPersistentProperty(WebCommonActivator.needFullInstallQName, Boolean.toString(needFullInstall));
    }

    public static boolean isWearable(IProject project) {
        String profileName = org.tizen.common.util.ProjectUtil.getTizenProjectDescription((IProject)project).getProfileName();
        return LaunchUtil.isWearable(profileName);
    }

    public static boolean isWearable(IDevice device) throws TimeoutException, SdbCommandRejectedException, IOException {
        if (device == null) {
            return false;
        }
        String profileName = device.getPlatformInfo().getProfileName();
        return LaunchUtil.isWearable(profileName);
    }

    public static boolean isWearable(String profileName) {
        String[] stringArray = TizenPlatformConstants.PROFILE_WEARABLES;
        int n = TizenPlatformConstants.PROFILE_WEARABLES.length;
        int n2 = 0;
        while (n2 < n) {
            String profile = stringArray[n2];
            if (profile.equalsIgnoreCase(profileName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static ILaunchConfiguration[] getLaunchConfigurations(String projectName) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = launchManager.getLaunchConfigurationType("org.tizen.web.zimlaunch.WebAppLaunch");
        ILaunchConfiguration[] configurations = launchManager.getLaunchConfigurations(type);
        ArrayList<ILaunchConfiguration> projectConfigurations = new ArrayList<ILaunchConfiguration>();
        ILaunchConfiguration[] iLaunchConfigurationArray = configurations;
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration configuration = iLaunchConfigurationArray[n2];
            String projectAttr = configuration.getAttribute("org.tizen.common.CONFIG_ATTR_PROJECT_NAME", "");
            if (projectAttr.equals(projectName)) {
                projectConfigurations.add(configuration);
            }
            ++n2;
        }
        return projectConfigurations.toArray(new ILaunchConfiguration[0]);
    }

    public static ILaunchConfigurationType getLaunchConfigurationType() {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configType = lm.getLaunchConfigurationType("org.tizen.web.zimlaunch.WebAppLaunch");
        return configType;
    }

    public static int getCurrentLaunchType(ILaunchConfiguration configuration, IProject project, String mode) throws CoreException {
        Assert.notNull((Object)configuration);
        Assert.notNull((Object)project);
        Assert.notNull((Object)mode);
        LaunchType currentLaunchType = LaunchType.UNKNOWN;
        currentLaunchType = configuration.getType().getName().equals("Tizen Web Unit Test") ? LaunchType.UNITTEST : ("debug".equals(mode) ? LaunchType.DEBUG : (configuration.getAttribute(TizenWebLaunchConstants.ATTR_LIVE_EDITING, false) ? LaunchType.LIVE_EDITING : (RdsPreferencePage.isWebRdsMode((IProject)project) ? LaunchType.RDS : (configuration.getAttribute(TizenWebLaunchConstants.ATTR_UPDATE_MODE, false) ? LaunchType.UPDATE : LaunchType.GENERAL))));
        return currentLaunchType.ordinal();
    }
}

