/*
*  Common
*
* Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
*
* Contact:
* ChangHyun Lee <changhyun1.lee@samsung.com>
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
* Contributors:
* - S-Core Co., Ltd
*
*/
package org.tizen.common;

import static org.junit.Assert.assertTrue;

import org.junit.Test;

/**
 * AppIdGeneratorTest.
 *
 * Test case for {@link AppIdGenerator}
 *
 * @author Changhyun Lee{@literal <changhyun1.lee@samsung.com>} (S-Core)
 *
 * @see AppIdGenerator
 *
 */
public class AppIdGeneratorTest {

    /**
     * Test {@link AppIdGenerator#generate()}
     *
     * @throws Exception in case of failure in test
     *
     * @see {@link AppIdGenerator#create()}
     */
    @Test
    public void test_create() throws Exception {
        String id = AppIdGenerator.getInstance().create();
        String id2 = AppIdGenerator.getInstance().create();
        assertTrue(id.length() == 10);
        assertTrue(id2.length() == 10);
    }

    /**
     * Test {@link AppIdGenerator#generate(int size)}
     *
     * @throws Exception in case of failure in test
     *
     * @see {@link AppIdGenerator#generate(int size)}
     */
    @Test
    public void test_generate() throws Exception {
        String id = AppIdGenerator.getInstance().generate(10);
        String id2 = AppIdGenerator.getInstance().generate(11);
        assertTrue(id.length() == 10);
        assertTrue(id2.length() == 11);
    }

}
