/*
*  Common
*
* Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
*
* Contact: 
* BonYong Lee <bonyong.lee@samsung.com>
* 
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
* Contributors:
* - S-Core Co., Ltd
*
*/
package org.tizen.common.core.application;

import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.verify;

import org.eclipse.jface.action.IStatusLineManager;
import org.junit.Test;


/**
 * StatusLineMessageManagerTest
 *
 * Test case for {@link StatusLineMessageManager}
 * 
 * @author BonYong Lee{@literal <bonyong.lee@samsung.com>} (S-Core)
 * 
 * @see StatusLineMessageManager
 */
public class StatusLineMessageManagerTest
{
	/**
	 * Test {@link StatusLineMessageManager#setMessage(String)}
	 * 
	 * @throws Exception in case of failure in test
	 * 
	 * @see {@link StatusLineMessageManager#setMessage(String)}
	 */
	@Test
	public void test_setMessage() throws Exception
	{
		final String[] TEST_CASES = new String[] {
			null, "Hello", "Test"
		};
		
		for ( final String TEST_CASE : TEST_CASES )
		{
			final IStatusLineManager statusLineManager = mock( IStatusLineManager.class );
			final StatusLineMessageManager manager =
				new StatusLineMessageManager( statusLineManager );
			
			manager.setMessage( TEST_CASE );
			verify( statusLineManager ).setMessage( TEST_CASE );
		}
	}

	/**
	 * Test {@link StatusLineMessageManager#setErrorMessage(String)}
	 * 
	 * @throws Exception in case of failure in test
	 * 
	 * @see {@link StatusLineMessageManager#setErrorMessage(String)}
	 */
	@Test
	public void test_setErrorMessage() throws Exception
	{
		final String[] TEST_CASES = new String[] {
			null, "Hello", "Test"
		};
		
		for ( final String TEST_CASE : TEST_CASES )
		{
			final IStatusLineManager statusLineManager = mock( IStatusLineManager.class );
			final StatusLineMessageManager manager =
				new StatusLineMessageManager( statusLineManager );
			
			manager.setErrorMessage( TEST_CASE );
			verify( statusLineManager ).setErrorMessage( TEST_CASE );
		}
	}

}
