/*
*  Common
*
* Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
*
* Contact: 
* GyeongSeok Seo <gyeongseok.seo@samsung.com>
* BonYong Lee <bonyong.lee@samsung.com>
* 
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
* Contributors:
* - S-Core Co., Ltd
*
*/
package org.tizen.common.core.command.sdb;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotSame;
import static org.junit.Assert.fail;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.verify;

import org.junit.Test;
import org.tizen.common.core.command.CommandTest;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.receiver.MultiLineReceiver;

/**
 * ShellSdbCommandTest
 *
 * Test case for {@link ShellSdbCommand}
 * 
 * @author GyeongSeok Seo{@literal <gyeongseok.seo@samsung.com>} (S-Core)
 * 
 * @see ShellSdbCommand
 */

public class
ShellSdbCommandTest
extends CommandTest
{
    @Test
    public void test_execute() throws Exception {
        String cmd = "ls";
        final MultiLineReceiver mockMultiLineReceiver = mock( MultiLineReceiver.class );
        ShellSdbCommand testCommand1 = new ShellSdbCommand();
        ShellSdbCommand testCommand2 = new ShellSdbCommand( cmd ) {
            @Override
            public MultiLineReceiver createMultiLineReceiver() {
                return mockMultiLineReceiver;
            }
            
        };

        // construction test
        assertEquals( testCommand1.getCommand(), null );
        assertEquals( testCommand2.getCommand(), cmd);

        // time value test
        assertEquals( testCommand1.getTime(), 90 );
        testCommand1.setTime( 30 );
        assertEquals( testCommand1.getTime(), 30 );
        testCommand1.setTime( 1 );
        assertEquals( testCommand1.getTime(), 1 );
        testCommand1.setTime( 0 );
        assertEquals( testCommand1.getTime(), 90 );
        testCommand1.setTime( -1 );
        assertEquals( testCommand1.getTime(), 90 );

        try {
            // device null test
            testCommand1.run( null, context );
            fail( "when device is null then must throw exception" );
        } catch (Exception e) {
        }

        IDevice mockDevice = mock( IDevice.class );
        testCommand1.setDevice( mockDevice );
        testCommand2.setDevice( mockDevice );
        try {
            // command null test
            testCommand1.run( null, context );
            fail( "when command is null then must throw exception" );
        } catch (Exception e) {
        }

        try {
            // normal operation test
            String clearResult =  "Test clearResult call";
            testCommand2.setResult( clearResult );
            testCommand2.run( null, context );

            // clearResult call test
            assertNotSame( clearResult, testCommand2.getResult() );
            // executeShellCommand call test
            verify( mockDevice ).executeShellCommand( cmd, mockMultiLineReceiver, 90000 );
        } catch (Exception e) {
            fail( "should't throw exception" );
        }
    }

}
