/*
 * Common
 *
 * Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact:
 * Ho Namkoong <ho.namkoong@samsung.com> 
 * BonYong Lee <bonyong.lee@samsung.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
 *
 */

package org.tizen.common.sdb;

import static org.junit.Assert.assertTrue;
import org.junit.Test;

/**
 * <p>
 * DevicesTest
 * 
 * Test case for sdb devices
 *
 * </p>
 * 
 * @author Ho Namkoong{@literal <ho.namkoong@samsung.com>} (S-Core)
 */
public class DevicesTest {
    
    /**
     * Test {sdb devices}
     * 
     * @author Ho Namkoong{@literal <ho.namkoong@samsung.com>} (S-Core)
     * 
     * command
     * sdb devices
     * expected result
     * emulator-{port}    device
     */
    @Test
    public void test_devices() throws Exception {
        int[] ports = SdbTestUtil.getPorts();
        
        for(int port: ports) {
            assertTrue(String.format("Invalid device port %d", port), port > 0 && port < 65535);
        }
    }
}
