/*
*  Common
*
* Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
*
* Contact: 
* BonYong Lee <bonyong.lee@samsung.com>
* 
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
* Contributors:
* - S-Core Co., Ltd
*
*/
package org.tizen.common.util;

import static org.junit.Assert.assertEquals;

import java.util.Arrays;

import org.junit.Test;


/**
 * CollectionMapTest
 *
 * Test case for {@link CollectionMap}
 * 
 * @author BonYong Lee{@literal <bonyong.lee@samsung.com>} (S-Core)
 * 
 * @see CollectionMap
 */
public class
CollectionMapTest
{
	/**
	 * Test {@link CollectionMap#put(Object, Object)}
	 * 
	 * @throws Exception in case of failure in test
	 * 
	 * @see CollectionMap#put(Object, Object)
	 */
	public
	void
	test_put()
	throws Exception {
		final CollectionMap<String, String> map = new CollectionMap<String, String>();
		
		map.put( "hello", "world1" );
		
		assertEquals( Arrays.asList( "world1" ), map.get( "hello" ) );
		map.put( "hello", "world2" );
		assertEquals( Arrays.asList( "world1", "world2" ), map.get( "hello" ) );
	}
	
	
	/**
	 * Test {@link CollectionMap#get(Object)}
	 * 
	 * @throws Exception in case of failure in test
	 * 
	 * @see CollectionMap#get(Object)
	 */
	@Test
	public
	void
	test_get()
	throws Exception
	{
		final CollectionMap<String, String> map = new CollectionMap<String, String>();
		
		map.put( "hello", "world1" );
		
		assertEquals( Arrays.asList( "world1" ), map.get( "hello" ) );
		map.put( "hello", "world2" );
		assertEquals( Arrays.asList( "world1", "world2" ), map.get( "hello" ) );
	}
	
	/**
	 * Test {@link CollectionMap#remove(Object)}
	 * 
	 * @throws Exception in case of failure in test
	 * 
	 * @see CollectionMap#remove(Object)
	 */
	@Test
	public
	void
	test_remove()
	throws Exception
	{
		final CollectionMap<String, String> map = new CollectionMap<String, String>();
		
		map.put( "hello", "world1" );
		map.put( "hello", "world2" );
		assertEquals( Arrays.asList( "world1", "world2" ), map.get( "hello" ) );

		map.remove( "hello", "world1" );
		assertEquals( Arrays.asList( "world2" ), map.get( "hello" ) );
		map.remove( "hello", "world1" );
		assertEquals( Arrays.asList( "world2" ), map.get( "hello" ) );
		map.remove( "hello", "world2" );
		assertEquals( null, map.get( "hello" ) );
	}
	

	/**
	 * Test {@link CollectionMap#toString()}
	 * 
	 * @throws Exception in case of failure in test
	 * 
	 * @see CollectionMap#toString()
	 */
	@Test
	public
	void
	test_toString()
	throws Exception
	{
		final CollectionMap<String, String> map = new CollectionMap<String, String>();
		map.put( "a", "b" );
		map.put( "a", "c" );
		
		assertEquals( "CollectionMap[a=[b, c]]", map.toString() );
		
		map.put( "c", "d" );
		assertEquals( "CollectionMap[a=[b, c], c=[d]]", map.toString() );
	}
}
