package org.tizen.common.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FontUtilTest {
    /**
     * Source directory for test
     */
    public static final String TEST_RESOURCE_SRC = "test/test_files";

    protected String oldConfig;
    
    @Before
    public void
    setUp()
    throws Exception
    {
        oldConfig = System.getProperty( "java.protocol.handler.pkgs" );
        System.setProperty( "java.protocol.handler.pkgs", "org.tizen.common.util.url" );
    }

    @After
    public
    void
    tearDown()
    {
        if ( null == oldConfig )
        {
            System.clearProperty( "java.protocol.handler.pkgs" );
        }
        else
        {
            System.setProperty( "java.protocol.handler.pkgs", oldConfig );
        }
    }

    @Test
    public void getFontFamilyName() throws FontException, MalformedURLException, URISyntaxException {
        String[][] tests = {
                {"kang inpyo.ttf", "kang inpyo"},
                {"seo minsu.ttf", "seo minsu"},
                {"SamsungSans_Lt.ttf", "Samsung Sans"},
                {"SamsungSans_Md.ttf", "Samsung Sans"},
                {"SamsungSans_Rg.ttf", "Samsung Sans"},
                {"NanumBarunGothic.otf", "NanumBarunGothicOTF"},
                {"NanumBarunGothicBold.otf", "NanumBarunGothicOTF"}};
        

        for (String[] test : tests) {
            File file = new File(FileUtil.appendPath(TEST_RESOURCE_SRC, test[0]));
            String fontFamilyName = FontUtil.getFontFamilyName(file.getAbsolutePath());
            Assert.assertEquals(test[1], fontFamilyName);
        }
    }
}
