/*
*  Common
*
* Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
*
* Contact: 
* BonYong Lee <bonyong.lee@samsung.com>
* 
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
* Contributors:
* - S-Core Co., Ltd
*
*/
package org.tizen.common.util;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import java.util.Random;

import org.junit.Test;


/**
 * LocalPortCheckerTest
 *
 * Test case for {@link LocalPortChecker}
 * 
 * @author BonYong Lee{@literal <bonyong.lee@samsung.com>} (S-Core)
 * 
 * @see LocalPortChecker
 */
public class LocalPortCheckerTest
{
	
	/**
	 * Test {@link LocalPortChecker#isPortInRange(int)}
	 * 
	 * @throws Exception in case of failure in test
	 * 
	 * @see LocalPortChecker#isPortInRange(int)
	 */
	@Test
	public void test_isPortInRange() throws Exception
	{
		for ( int i = 0 ; i < 65536 ; ++i )
		{
			assertTrue( LocalPortChecker.isPortInRange( i ) );
		}
		assertFalse( LocalPortChecker.isPortInRange( -1 ) );
		assertFalse( LocalPortChecker.isPortInRange( 65536 ) );
	}
	
	/**
	 * Test {@link LocalPortChecker#isPortAvailable(int)}
	 * 
	 * @throws Exception in case of failure in test
	 * 
	 * @see LocalPortChecker#isPortAvailable(int)
	 */
	@Test
	public void test_isPortAvailable() throws Exception
	{
		assertFalse( LocalPortChecker.isPortAvailable( -1 ) );
		assertTrue( LocalPortChecker.isPortAvailable( 0 ) );
		assertFalse( LocalPortChecker.isPortAvailable( 65538 ) );
	}
	
	/**
	 * Test {@link LocalPortChecker#getAvailableLocalPort(int, int)}
	 * 
	 * @throws Exception in case of failure in test
	 * 
	 * @see LocalPortChecker#getAvailableLocalPort(int, int)
	 */
	@Test
	public void test_getAvailableLocalPort() throws Exception
	{
		final Random r = new Random( System.currentTimeMillis() );
		final int MIN = 10000;
		final int MAX = 65535;
		
		for ( int i = 0 ; i < 1000 ; ++i )
		{
			final int basePort = r.nextInt( MAX - MIN ) + MIN;
			final int inc = r.nextInt( 5 ) - 2;

			int port = LocalPortChecker.getAvailableLocalPort( inc, basePort );
			assertEquals( "base port :" + basePort + ", inc :" + inc + ", real port :" + port, ( basePort == port ), LocalPortChecker.isPortAvailable( basePort ) );
		}
	}

}
