/*
 *  Common
 *
 * Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact: 
 * Ho Namkoong <ho.namkoong@samsung.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
 *
 */

package org.tizen.common.util;

import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.tizen.common.Surrogate;

/**
 * PluginUtilTest.
 *
 * Test case for {@link PluginUtil}
 * 
 * @author Ho Namkoong{@literal <ho.namkoong@samsung.com>} (S-Core)
 * 
 * @see PluginUtil
 */
@SuppressWarnings("unchecked")
public class PluginUtilTest {

    /**
     * mock up test extension point id
     */
    public static String TEST_EXT_ID = "test-ep";
    
    /**
     * mock up test class id
     */
    public static String TEST_CLS_ID = "test-class";
    
    /**
     * mock up IConfigurationElement
     */
    public static IConfigurationElement config;
    
    @Before
    public void setUp() {
        PluginUtil.platformSurrogate = mock(Surrogate.class);
        
        final IExtensionRegistry registry = mock(IExtensionRegistry.class);
        when(PluginUtil.platformSurrogate.getAdapter()).thenReturn(registry);
        
        final IExtensionPoint ep = mock(IExtensionPoint.class);
        when(registry.getExtensionPoint(TEST_EXT_ID)).thenReturn(ep);
        
        IExtension[] exts = new IExtension[1];
        when(ep.getExtensions()).thenReturn(exts);
        
        final IExtension ext = mock(IExtension.class);
        exts[0] = ext;
        
        final IConfigurationElement[] configs = new IConfigurationElement[1];
        when(ext.getConfigurationElements()).thenReturn(configs);
        
        config = mock(IConfigurationElement.class);
        configs[0] = config;
    }
    
    @After
    public void tearDown() {
        PluginUtil.platformSurrogate = null;
    }

    /**
     * Test {@link PluginUtil#loadClasses(String)}
     * 
     * @throws Exception in case of failure in test
     * 
     * @see PluginUtil#loadClasses(String)
     */
    @Test
    public void testLoadClasses() throws Exception {
        PluginUtil.loadClasses(TEST_EXT_ID);
        Mockito.verify(config).createExecutableExtension("class");
    }

    /**
     * Test {@link PluginUtil#loadClass(String, String)}
     * 
     * @throws Exception in case of failure in test
     * 
     * @see PluginUtil#loadClass(String, String)
     */
    @Test
    public void testLoadClass() throws Exception {
        when(config.getAttribute("id")).thenReturn(TEST_CLS_ID);
        
        PluginUtil.loadClass(TEST_EXT_ID, TEST_CLS_ID);
        Mockito.verify(config).createExecutableExtension("class");
    }

    /**
     * Test {@link PluginUtil#getExtensionAttribute(String, String)}
     * 
     * @throws Exception in case of failure in test
     * 
     * @see PluginUtil#getExtensionAttribute(String, String)
     */
    @Test
    public void testGetExtensionAttribute() throws Exception {
        when(config.getAttribute("extension")).thenReturn("css");
        PluginUtil.getExtensionAttribute(TEST_EXT_ID, "extension");
        Mockito.verify(config).getAttribute("extension");
    }
}
