/*
*  Common
*
* Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
*
* Contact: 
* BonYong Lee <bonyong.lee@samsung.com>
* 
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
* Contributors:
* - S-Core Co., Ltd
*
*/
package org.tizen.common.util;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import org.eclipse.swt.widgets.Display;
import org.junit.Test;



/**
 * SWTUtilTest.
 * 
 * Test case for {@link SWTUtil}
 * 
 * @author BonYong Lee{@literal <bonyong.lee@samsung.com>} (S-Core)
 * 
 * @see SWTUtil
 */
public class SWTUtilTest
{
	/**
	 * Test {@link SWTUtil#getDisplay()}
	 * 
	 * @throws Exception in case of failure in test
	 * 
	 * @see {@link SWTUtil#getDisplay()}
	 */
	@Test
	public void test_getDisplay() throws Exception {
		Display dp = SWTUtil.getDisplay();
		assertNotNull( dp );
		dp.dispose();
	}
	
	/**
	 * Test {@link SWTUtil#asynExec()}
	 * 
	 * @throws Exception in case of failure in test
	 * 
	 * @see {@link SWTUtil#asynExec()}
	 */
	@Test
	public void test_asynExec() throws Exception {
		MockRunner runnable = new MockRunner();
		assertFalse( runnable.bExecute );
		Display dp = SWTUtil.getDisplay();
		SWTUtil.asyncExec( dp, runnable );
		assertFalse( runnable.bExecute );
		
		long start = System.currentTimeMillis();
		while ( !runnable.bExecute && (System.currentTimeMillis() - start) < 100 )
		{
			if ( !dp.readAndDispatch() )
			{
				dp.sleep();
			}
		}
		assertTrue( runnable.bExecute );
	}
	
	/**
	 * Test {@link SWTUtil#isHtmlFile()}
	 * 
	 * @throws Exception in case of failure in test
	 * 
	 * @see {@link SWTUtil#isHtmlFile()}
	 */
	@Test
	public void test_isHtmlFile() throws Exception {
		final Object[][] TEST_CASES = new Object[][] {
				new Object[] { "aaaa.exe", false },
				new Object[] { "index.html", true },
				new Object[] { "index.test.html", true },
				new Object[] { "index..html", true },
				new Object[] { ".profile", false },
				new Object[] { "ReadMe ", false },
				new Object[] { "ReadMe", false },
				new Object[] { "ReadMe. ", false },
				new Object[] { "ReadMe. test", false }
		};

		for ( final Object[] TEST_CASE : TEST_CASES )
		{
			final String fileName = (String) TEST_CASE[0];
			final boolean expected = (Boolean) TEST_CASE[1];
			
			
			/*
			 * LookAtMe : Attach title when looping test case
			 */
			assertEquals( "input :" + fileName, expected, SWTUtil.isHtmlFile( fileName ) );
		}
		
	}

}
