/*
*  Common
*
* Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
*
* Contact: 
* BonYong Lee <bonyong.lee@samsung.com>
* 
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
* Contributors:
* - S-Core Co., Ltd
*
*/
package org.tizen.common.util;

import static org.junit.Assert.*;

import org.junit.Test;


/**
 * ThreadUtilTest
 * 
 * Test case for {@link ThreadUtil}
 * 
 * @author BonYong Lee{@literal <bonyong.lee@samsung.com>} (S-Core)
 * 
 * @see ThreadUtil
 */
public class ThreadUtilTest {
	
	/**
	 * Test {@link ThreadUtil#trySleep(long)}
	 * 
	 * @throws Exception in case of failure in test
	 * 
	 * @see {@link ThreadUtil#trySleep(long)}
	 */
	@Test
	public void test_trySleep() throws Exception {
		final Object[][] TEST_CASES = new Object[][] {
				new Object[] { 100, 100 },
				new Object[] { 0, 0 },
				new Object[] { -100, 0 }
		};
		
		for ( final Object[] TEST_CASE : TEST_CASES )
		{
			final int milliseconds = (Integer) TEST_CASE[0];
			final int expected = (Integer) TEST_CASE[1];
			
			long start = System.currentTimeMillis();
			ThreadUtil.trySleep( milliseconds );
			long end = System.currentTimeMillis();
			
			long result = end - start;
			
			assertTrue( "input: " + milliseconds + ", expected: " + expected + ", result: " + result, expected <= result );
		}
	}
}
