/*
 * Common
 *
 * Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact: 
 * BonYong Lee <bonyong.lee@samsung.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
 *
 */
package org.tizen.common.util.io;

import static org.junit.Assert.assertEquals;
import static org.tizen.common.util.IOUtil.tryClose;

import java.nio.ByteBuffer;
import java.util.ArrayList;

import org.junit.Test;


/**
 * BufferPoolTest
 *
 * Test case for {@link BufferPool}
 * 
 * @author BonYong Lee{@literal <bonyong.lee@samsung.com>} (S-Core)
 * 
 * @see BufferPool
 */
public class
BufferPoolTest
{
	/**
	 * Test {@link BufferPool#setSizeOfFragment(int)}
	 * 
	 * @throws Exception in case of failure in test
	 * 
	 * @see {@link BufferPool#setSizeOfFragment(int)}
	 */
	@Test
	public
	void
	test_setSizeOfFragment()
	throws Exception
	{
		final ArrayList<ByteBuffer> tempPool = new ArrayList<ByteBuffer>();

		final BufferPool pool = new BufferPool();

		pool.setSizeOfFragment( 10 );
		pool.setNumberOfFragments( 10 );

		try {
			for ( int i = 0 ; i < 9 ; ++i )
			{
				tempPool.add( pool.borrow() );
			}
			pool.setSizeOfFragment( 20 );
			ByteBuffer buffer = pool.borrow();
			assertEquals( 10, buffer.limit() );
			tempPool.add( buffer );
		}
		finally
		{
			for ( ByteBuffer buffer : tempPool )
			{
				pool.release( buffer );
			}
			
			tryClose( pool );
			
		}
	}

}
