package org.tizen.common;

import static org.junit.Assert.assertArrayEquals;
import static org.junit.Assert.assertTrue;
import static org.tizen.common.util.IOUtil.tryClose;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

import org.junit.Test;

public class LogConverterTest
{

    @Test
    public
    void
    test_parse()
    throws Exception
    {
        final Object[][] TEST_CASES = new Object[][] {
            new Object[] {
                "[2013.10.10 15:00:18][PERFORM_E] TizenLaunchDelegate.java(804) - [Category: native.launch\tVariable: .install] at 2013-10-10 15:00:18.223 \t [2917(ms)]", new String[] { "native.launch", ".install", "2917" },
            },
            new Object[] {
                "[2013.10.15 12:12:53][PERFORM_E] TemplateCopyOperation.java(70) - [Category: web.wizard\tVariable: web.wizard.finish.TemplateCopyOperation] at 2013-10-15 12:12:53.950 \t [24(ms)]", new String[] { "web.wizard", "web.wizard.finish.TemplateCopyOperation", "24" }
            }
        };
        
        final LogConverter target = new LogConverter();
        for ( final Object[] TEST_CASE : TEST_CASES )
        {
            final String input = (String) TEST_CASE[0];
            System.out.println( input );
            final String[] expect = (String[]) TEST_CASE[1];
            final String[] result = target.parse( input );
            
            assertArrayEquals( expect, result );
        }
        
        final InputStream in = getClass().getResourceAsStream( "/" + getClass().getPackage().getName().replace( '.', '/' ) + "/IDE-TEST.20131015.120932.log" );

        if ( null != in )
        {
            final ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            try
            {
                target.convert( new InputStreamReader( in ), new OutputStreamWriter( byteOut ) );
            }
            finally
            {
                tryClose( in );
                tryClose( byteOut );
            }
            
            assertTrue( 0 < byteOut.size() );
            
        }
    }

}
