/*
 *  Common
 *
 * Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact: 
 * BonYong Lee <bonyong.lee@samsung.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
 *
 */
package org.tizen.common.config;

import static org.junit.Assert.assertEquals;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.tizen.common.config.provider.PropertiesProvider;

/**
 * ExpressionParserTest
 *
 * Test case for {@link ExpressionParser}
 * 
 * @author BonYong Lee{@literal <bonyong.lee@samsung.com>} (S-Core)
 * 
 * @see ExpressionParser
 */
public class
ExpressionParserTest
{
    /**
     * Prepare test
     * 
     * @throws Exception in case of failure in preparation
     */
    @Before
	public
	void
	setUp()
	throws Exception {
		final String[][] CONFIGS = new String[][] {
			new String[] { "msg1", "hello" },
			new String[] { "msg2", "${msg3}, ${msg4}!!" },
			new String[] { "msg5", "${msg6}, ${msg7}!!" },
			new String[] { "msg6", "hello" },
			new String[] { "msg7", "world" },
			new String[] { "msg8", "${msg9" },
			new String[] { "msg9", "$abcd" },
			new String[] { "msg10", "^${abc}" }
		};

		PropertiesProvider provider = new PropertiesProvider();
		for ( final String[] CONFIG : CONFIGS )
		{
			final String key = CONFIG[0];
			final String exp = CONFIG[1];

			provider.set( key, exp );
		}
		
		
		Preference.register( "default", provider );
	}

	/**
	 * clean up test case
	 * 
	 * @throws Exception in case of failure in clean-up
	 */
	@After
	public
	void
	tearDown()
	throws Exception {
		Preference.clear();
	}

    /**
     * Test {@link ExpressionParser#parse(String)}
     * 
     * @throws Exception in case of failure in test
     * 
     * @see {@link ExpressionParser#parse(String)}
     */
	@Test
	public
	void
	test_parse()
	throws Exception {
		final String[][] TEST_CASES = new String[][] {
			new String[] { "msg1", "hello" },
			new String[] { "msg2", "${msg3}, ${msg4}!!" },
			new String[] { "msg5", "hello, world!!" },
			new String[] { "msg8", "${msg9" },
			new String[] { "msg9", "$abcd" },
			new String[] { "msg10", "${abc}" }
		};


		for ( final String[] TEST_CASE : TEST_CASES )
		{
			final String key = TEST_CASE[0];
			final String value = TEST_CASE[1];

			assertEquals( "Key :" + key  + ", Value :" + value, value, Preference.getValue( key, null ) );
		}
	}


}
