/*
 *  Common
 *
 * Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact: 
 * BonYong Lee <bonyong.lee@samsung.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
 *
 */
package org.tizen.common.config;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import static org.tizen.common.util.IOUtil.tryClose;

import java.io.InputStream;
import java.util.Properties;

import org.junit.Test;
import org.tizen.common.config.provider.PropertiesProvider;


/**
 * PreferenceTest
 *
 * Test case for {@link Preference}
 * 
 * @author BonYong Lee{@literal <bonyong.lee@samsung.com>} (S-Core)
 * 
 * @see Preference
 */
public class
PreferenceTest
{
    /**
     * Test {@link Preference#checkName(String)}
     * 
     * @throws Exception in case of failure in test
     * 
     * @see {@link Preference#checkName(String)}
     */
	public void 
	test_checkName()
	throws Exception {
		assertTrue( Preference.checkName( "ajfdkfj" ) );
		assertTrue( Preference.checkName( "344223" ) );
		assertTrue( Preference.checkName( "한글" ) );

		assertFalse( Preference.checkName( "344 223" ) );
	}

    /**
     * Test {@link Preference#getValue(String, String)}
     * 
     * @throws Exception in case of failure in test
     * 
     * @see {@link Preference#getValue(String, String)}
     */
	@Test
	public
	void
	test_getValue()
	throws Exception
	{
		final ClassLoader cl = getClass().getClassLoader();

		final String path =
		PreferenceTest.class.getPackage().getName().replace( '.', '/') + "/test.properties";
		final InputStream in =
			cl.getResourceAsStream( path );

		try
		{
			final Properties props = new Properties();
			props.load( in );

			assertEquals( null, Preference.getValue( "hello", null ) );
			
			final PropertiesProvider provider = new PropertiesProvider( props );
			Preference.register( "test", provider );

			assertEquals( "world", Preference.getValue( "hello", null ) );
			assertEquals( "c", Preference.getValue( "a", null ) );
			assertEquals( null, Preference.getValue( "hello1", null ) );
			assertEquals( "e", Preference.getValue( "hello1", "${d}" ) );
		}
		finally
		{
			tryClose( in );
		}
	}

}
