/*
 * Common
 *
 * Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact: 
 * BonYong Lee <bonyong.lee@samsung.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
 *
 */
package org.tizen.common.core.command.prompter;

import static org.junit.Assert.assertEquals;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.junit.Test;


/**
 * SWTPrompterTest
 *
 * Test case for {@link SWTPrompter}
 * 
 * @author BonYong Lee{@literal <bonyong.lee@samsung.com>} (S-Core)
 * 
 * @see SWTPrompter
 */
public class
SWTPrompterTest
{
	/**
	 * Test {@link SWTPrompter#interact(String, ChoiceOption...)}
	 * 
	 * @throws Exception in case of failure in test
	 * 
	 * @see SWTPrompter#interact(String, ChoiceOption...)
	 */
	@Test
	public void test_interact() throws Exception {
		{
			// Given
			final MessageDialog mockDialog = mock( MessageDialog.class );
			when( mockDialog.getReturnCode() ).thenReturn( 0 );
			final SWTPrompter prompter = new SWTPrompter() {
				@Override
				protected Dialog createDialog(
					final String question,
					final String[] optionNames,
					final int defaultOptionIndex
				)
				{
					return mockDialog;
				}
			};
			
			// When
			ChoiceOption opt1 = new ChoiceOption( "Yes" );
			ChoiceOption opt2 = new ChoiceOption( "No", true );
			
			// Then
			Option result = prompter.interact( "Yes or No", opt1, opt2 );
			assertEquals( opt1, result );
		}
		
		{
			// Given
			final MessageDialog mockDialog = mock( MessageDialog.class );
			when( mockDialog.getReturnCode() ).thenReturn( 1 );
			final SWTPrompter prompter = new SWTPrompter() {
				@Override
				protected Dialog createDialog(
					final String question,
					final String[] optionNames,
					final int defaultOptionIndex
				)
				{
					return mockDialog;
				}
			};
			
			// When
			ChoiceOption opt1 = new ChoiceOption( "Yes" );
			ChoiceOption opt2 = new ChoiceOption( "No", true );
			
			// Then
			Option result = prompter.interact( "Yes or No", opt1, opt2 );
			assertEquals( opt2, result );

		}
	}

}
