/*
*  Common
*
* Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
*
* Contact: 
* GyeongSeok Seo <gyeongseok.seo@samsung.com>
* BonYong Lee <bonyong.lee@samsung.com>
* 
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
* Contributors:
* - S-Core Co., Ltd
*
*/
package org.tizen.common.core.command.sdb;

import static org.junit.Assert.*;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.verify;

import org.junit.Test;
import org.tizen.common.core.command.CommandTest;
import org.tizen.sdblib.IDevice;

/**
 * ForwardSdbCommandTest
 *
 * Test case for {@link ForwardSdbCommand}
 * 
 * @author GyeongSeok Seo{@literal <gyeongseok.seo@samsung.com>} (S-Core)
 * 
 * @see ForwardSdbCommand
 */
public class
ForwardSdbCommandTest
extends CommandTest
{
    @Test
    public void test_execute() throws Exception {
        int localPort = 5000;
        int remotePort = 4000;
        ForwardSdbCommand testCommand = new ForwardSdbCommand(localPort, remotePort);

        // device null test
        try {
            testCommand.run( null, context );
            fail( "when device is null then must throw exception" );
        } catch (Exception e) {
        }

        try {
            IDevice mockDevice = mock( IDevice.class );
            testCommand.setDevice( mockDevice );
            testCommand.run( null, context );
            verify( mockDevice ).createForward( localPort, remotePort );
        } catch (Exception e) {
            fail( "should't throw exception" );
        }
    }

    @Test
    public void test_undo() throws Exception {
        int localPort = 5000;
        int remotePort = 4000;
        ForwardSdbCommand testCommand = new ForwardSdbCommand(localPort, remotePort);

        // device null test
        try {
            testCommand.undo( null, context );
            fail( "when device is null then must throw exception" );
        } catch (Exception e) {
        }

        try {
            IDevice mockDevice = mock( IDevice.class );
            testCommand.setDevice( mockDevice );
            testCommand.undo( null, context );
            verify( mockDevice ).removeForward( localPort, remotePort );
        } catch (Exception e) {
            fail( "should't throw exception" );
        }
    }
}
