/*
 * Common
 *
 * Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact: 
 * BonYong Lee <bonyong.lee@samsung.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
 *
 */
package org.tizen.common.daemon;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import java.util.concurrent.atomic.AtomicInteger;

import org.junit.Test;
import org.tizen.common.util.ThreadUtil;

public class AbstractServerTest
{

    @Test
    public void test_boot() throws Exception
    {
        final AtomicInteger status = new AtomicInteger();
        
        AbstractServer server = new AbstractServer()
        {
            
            @Override
            protected void terminate()
            {
                ThreadUtil.trySleep( 200 );
                status.incrementAndGet();
            }
            
            @Override
            protected void process() throws Exception
            {
                ThreadUtil.trySleep( 200 );
            }
            
            @Override
            protected void initialize() throws ServerException
            {
                ThreadUtil.trySleep( 200 );
                status.incrementAndGet();
            }
            
            @Override
            public String getName()
            {
                return null;
            }
        };
        
        server.boot();
        try
        {
            server.boot();
            fail();
        } catch ( IllegalStateException e )
        {
        }
        server.waitState( ServerState.Running );
        assertEquals( 1, status.intValue() );
        
        server.down();
        try
        {
            server.down();
            fail();
        } catch ( IllegalStateException e )
        {
        }
        server.waitState( ServerState.Terminated );
        assertEquals( 2, status.intValue() );
        
    }

}
