/*
 * Common
 *
 * Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact:
 * Ho Namkoong <ho.namkoong@samsung.com> 
 * BonYong Lee <bonyong.lee@samsung.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
 *
 */

package org.tizen.common.sdb;

import static org.junit.Assert.*;
import static org.tizen.common.sdb.SdbTestUtil.*;
import static org.tizen.common.Shell.*;

import java.text.MessageFormat;

import org.junit.Test;
import org.tizen.common.Pattern;

/**
 * <p>
 * StatusWindowTest
 * 
 * Test case for sdb status-window
 *
 * </p>
 * 
 * @author Ho Namkoong{@literal <ho.namkoong@samsung.com>} (S-Core)
 */
public class StatusWindowTest {
    
    /**
     * Test {sdb status-window}
     * 
     * @author Ho Namkoong{@literal <ho.namkoong@samsung.com>} (S-Core) 
     */
    @Test
    public void test_status_window() throws Exception {
        
        class StatusWindowResult {
            @Pattern(pattern = "State:{0}", index = 0)
            public String state;
        }
        
        String[] serials = getSerialNumber();
        StatusWindowResult result = run(String.format("%s -s %s %s", SDB_PATH, serials[0], "status-window")).
                expect(new StatusWindowResult(), 2000);
        assertNotNull("result of status-window is null", result.state);
        assertTrue(MessageFormat.format("unexpected state: {0}", result.state), 
                result.state.equals("device") || result.state.equals("offline"));
        
    }

}
