/*
*  Common
*
* Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
*
* Contact: 
* BonYong Lee <bonyong.lee@samsung.com>
* 
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
* Contributors:
* - S-Core Co., Ltd
*
*/
package org.tizen.common.ui.page.preference;

import static org.junit.Assert.assertFalse;

import org.junit.Test;
import org.tizen.common.util.StringUtil;

/**
 * MessagesTest
 *
 * Test case for {@link MessagesTest}
 *
 * @author BonYong Lee{@literal <bonyong.lee@samsung.com>} (S-Core)
 * @see MessagesTest
 */
public class MessagesTest {
    /**
     * Test {@link Messages}
     *
     * @throws Exception in case of failure in test
     *
     * @see {@link Messages}
     * @see Messages#DESCRIPTION
     * @see Messages#GROUP1
     * @see Messages#GROUP2
     * @see Messages#LABEL_LOCATION
     * @see Messages#LABEL_UPDATE
     */
    @Test
    public void test_Messages() throws Exception {
        assertFalse( StringUtil.isEmpty( Messages.DESCRIPTION ) );
        assertFalse( StringUtil.isEmpty( Messages.GROUP ) );
        assertFalse( StringUtil.isEmpty( Messages.LOCATION ) );
    }

}
